/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.cache.IdentityCache;
import org.apache.cxf.sts.cache.MemoryIdentityCacheStatistics;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;

public abstract class AbstractIdentityCache
implements IdentityCache,
IdentityMapper,
ManagedComponent {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractIdentityCache.class);
    private final IdentityMapper identityMapper;
    private final Bus bus;
    private MemoryIdentityCacheStatistics statistics;

    public AbstractIdentityCache(IdentityMapper identityMapper) {
        this(null, identityMapper);
    }

    public AbstractIdentityCache(Bus bus, IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
        this.bus = bus;
    }

    @Override
    public Principal mapPrincipal(String sourceRealm, Principal sourcePrincipal, String targetRealm) {
        Principal targetPrincipal = null;
        Map<String, String> identities = this.get(sourcePrincipal.getName(), sourceRealm);
        if (identities != null) {
            String targetUser;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Identities found for '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
            }
            if ((targetUser = identities.get(targetRealm)) == null) {
                this.getStatistics().increaseCacheMiss();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No mapping found for realm " + targetRealm + " of user '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
                }
                targetPrincipal = this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm);
                identities.put(targetRealm, targetPrincipal.getName());
                Map<String, String> cachedItem = this.get(targetPrincipal.getName(), targetRealm);
                if (cachedItem != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Merging mappings for '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
                    }
                    this.mergeMap(identities, cachedItem);
                }
                this.add(targetPrincipal.getName(), targetRealm, identities);
            } else {
                this.getStatistics().increaseCacheHit();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Mapping '" + sourcePrincipal.getName() + "@" + sourceRealm + "' to '" + targetUser + "@" + targetRealm + "' cached");
                }
                targetPrincipal = new CustomTokenPrincipal(targetUser);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No mapping found for realm " + targetRealm + " of user '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
            }
            this.getStatistics().increaseCacheMiss();
            targetPrincipal = this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm);
            identities = new HashMap<String, String>();
            identities.put(sourceRealm, sourcePrincipal.getName());
            identities.put(targetRealm, targetPrincipal.getName());
            this.add(targetPrincipal.getName(), targetRealm, identities);
            this.add(sourcePrincipal.getName(), sourceRealm, identities);
        }
        return targetPrincipal;
    }

    public MemoryIdentityCacheStatistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new MemoryIdentityCacheStatistics(this.bus, this);
        }
        return this.statistics;
    }

    public void setStatistics(MemoryIdentityCacheStatistics stats) {
        this.statistics = stats;
    }

    private void mergeMap(Map<String, String> to, Map<String, String> from) {
        for (Map.Entry<String, String> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : to.entrySet()) {
            from.put(entry.getKey(), entry.getValue());
        }
    }

    protected Bus getBus() {
        return this.bus;
    }
}

