/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.token.realm.SAMLRealm;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;

public abstract class AbstractSAMLTokenProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSAMLTokenProvider.class);

    protected void signToken(SamlAssertionWrapper assertion, SAMLRealm samlRealm, STSPropertiesMBean stsProperties, KeyRequirements keyRequirements) throws Exception {
        String signatureAlgorithm;
        Crypto signatureCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        SignatureProperties signatureProperties = stsProperties.getSignatureProperties();
        String alias = stsProperties.getSignatureUsername();
        if (samlRealm != null) {
            if (samlRealm.getSignatureCrypto() != null) {
                LOG.fine("SAMLRealm signature keystore used");
                signatureCrypto = samlRealm.getSignatureCrypto();
                callbackHandler = samlRealm.getCallbackHandler();
                alias = samlRealm.getSignatureAlias();
            }
            if (samlRealm.getSignatureProperties() != null) {
                signatureProperties = samlRealm.getSignatureProperties();
            }
        }
        if ((signatureAlgorithm = keyRequirements.getSignatureAlgorithm()) == null) {
            signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
        } else {
            List<String> supportedAlgorithms = signatureProperties.getAcceptedSignatureAlgorithms();
            if (!supportedAlgorithms.contains(signatureAlgorithm)) {
                signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
                LOG.fine("SignatureAlgorithm not supported, defaulting to: " + signatureAlgorithm);
            }
        }
        String c14nAlgorithm = keyRequirements.getC14nAlgorithm();
        if (c14nAlgorithm == null) {
            c14nAlgorithm = signatureProperties.getC14nAlgorithm();
        } else {
            List<String> supportedAlgorithms = signatureProperties.getAcceptedC14nAlgorithms();
            if (!supportedAlgorithms.contains(c14nAlgorithm)) {
                c14nAlgorithm = signatureProperties.getC14nAlgorithm();
                LOG.fine("C14nAlgorithm not supported, defaulting to: " + c14nAlgorithm);
            }
        }
        if ((alias == null || "".equals(alias)) && signatureCrypto != null) {
            alias = signatureCrypto.getDefaultX509Identifier();
            LOG.fine("Signature alias is null so using default alias: " + alias);
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(alias, 3)};
        LOG.fine("Creating SAML Token");
        callbackHandler.handle((Callback[])cb);
        String password = cb[0].getPassword();
        LOG.fine("Signing SAML Token");
        boolean useKeyValue = signatureProperties.isUseKeyValue();
        assertion.signAssertion(alias, password, signatureCrypto, useKeyValue, c14nAlgorithm, signatureAlgorithm, signatureProperties.getDigestAlgorithm());
    }
}

