/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.EvictionConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class EvictionBuilder
extends CacheComponentBuilder<EvictionConfiguration>
implements ResourceServiceBuilder<EvictionConfiguration> {
    private final EvictionConfigurationBuilder builder = new ConfigurationBuilder().eviction();

    EvictionBuilder(String containerName, String cacheName) {
        super(CacheComponent.EVICTION, containerName, cacheName);
    }

    public Builder<EvictionConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        EvictionStrategy strategy = (EvictionStrategy)ModelNodes.asEnum((ModelNode)EvictionResourceDefinition.Attribute.STRATEGY.getDefinition().resolveModelAttribute(context, model), EvictionStrategy.class);
        this.builder.strategy(strategy);
        this.builder.maxEntries(strategy.isEnabled() ? EvictionResourceDefinition.Attribute.MAX_ENTRIES.getDefinition().resolveModelAttribute(context, model).asLong() : -1L);
        return this;
    }

    public EvictionConfiguration getValue() {
        return this.builder.create();
    }
}

