/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPHandler;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeStatus;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

class MCMPWebManager
extends MCMPHandler {
    private final boolean checkNonce;
    private final boolean reduceDisplay;
    private final boolean allowCmd;
    private final Random r = new SecureRandom();
    private String nonce = null;

    public MCMPWebManager(MCMPConfig.MCMPWebManagerConfig config, ModCluster modCluster, HttpHandler next) {
        super(config, modCluster, next);
        this.checkNonce = config.isCheckNonce();
        this.reduceDisplay = config.isReduceDisplay();
        this.allowCmd = config.isAllowCmd();
    }

    String getNonce() {
        return "nonce=" + this.getRawNonce();
    }

    synchronized String getRawNonce() {
        if (this.nonce == null) {
            byte[] nonce = new byte[16];
            this.r.nextBytes(nonce);
            this.nonce = "";
            for (int i = 0; i < 16; i += 2) {
                this.nonce = this.nonce.concat(Integer.toHexString(0xFF & nonce[i] * 16 + 255 & nonce[i + 1]));
            }
        }
        return this.nonce;
    }

    @Override
    protected void handleRequest(HttpString method, HttpServerExchange exchange) throws Exception {
        if (!Methods.GET.equals(method)) {
            super.handleRequest(method, exchange);
            return;
        }
        this.processRequest(exchange);
    }

    private void processRequest(HttpServerExchange exchange) throws IOException {
        String receivedNonce;
        Map<String, Deque<String>> params = exchange.getQueryParameters();
        boolean hasNonce = params.containsKey("nonce");
        int refreshTime = 0;
        if (this.checkNonce && hasNonce && (receivedNonce = params.get("nonce").getFirst()).equals(this.getRawNonce())) {
            boolean refresh = params.containsKey("refresh");
            if (refresh) {
                String sval = params.get("refresh").getFirst();
                refreshTime = Integer.parseInt(sval);
                if (refreshTime < 10) {
                    refreshTime = 10;
                }
                exchange.getResponseHeaders().add(new HttpString("Refresh"), Integer.toString(refreshTime));
            }
            boolean cmd = params.containsKey("Cmd");
            boolean range = params.containsKey("Range");
            if (cmd) {
                String scmd = params.get("Cmd").getFirst();
                if (scmd.equals("INFO")) {
                    this.processInfo(exchange);
                    return;
                }
                if (scmd.equals("DUMP")) {
                    this.processDump(exchange);
                    return;
                }
                if (scmd.equals("ENABLE-APP") && range) {
                    boolean domain;
                    String srange = params.get("Range").getFirst();
                    MCMPHandler.RequestData requestData = MCMPWebManager.buildRequestData(exchange, params);
                    if (srange.equals("NODE")) {
                        this.processNodeCommand(exchange, requestData, MCMPHandler.MCMPAction.DISABLE);
                    }
                    if (srange.equals("DOMAIN") && (domain = params.containsKey("Domain"))) {
                        String sdomain = params.get("Domain").getFirst();
                        this.processDomainCmd(exchange, sdomain, MCMPHandler.MCMPAction.ENABLE);
                    }
                    if (srange.equals("CONTEXT")) {
                        this.processAppCommand(exchange, requestData, MCMPHandler.MCMPAction.ENABLE);
                    }
                } else if (scmd.equals("DISABLE-APP") && range) {
                    boolean domain;
                    String srange = params.get("Range").getFirst();
                    MCMPHandler.RequestData requestData = MCMPWebManager.buildRequestData(exchange, params);
                    if (srange.equals("NODE")) {
                        this.processNodeCommand(exchange, requestData, MCMPHandler.MCMPAction.DISABLE);
                    }
                    if (srange.equals("DOMAIN") && (domain = params.containsKey("Domain"))) {
                        String sdomain = params.get("Domain").getFirst();
                        this.processDomainCmd(exchange, sdomain, MCMPHandler.MCMPAction.DISABLE);
                    }
                    if (srange.equals("CONTEXT")) {
                        this.processAppCommand(exchange, requestData, MCMPHandler.MCMPAction.DISABLE);
                    }
                }
                return;
            }
        }
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/html; charset=ISO-8859-1");
        Sender resp = exchange.getResponseSender();
        StringBuilder buf = new StringBuilder();
        buf.append("<html><head>\n<title>Mod_cluster Status</title>\n</head><body>\n");
        buf.append("<h1>" + MOD_CLUSTER_EXPOSED_VERSION + "</h1>");
        String uri = exchange.getRequestPath();
        String nonce = this.getNonce();
        if (refreshTime <= 0) {
            buf.append("<a href=\"").append(uri).append("?").append(nonce).append("&refresh=").append(refreshTime).append("\">Auto Refresh</a>");
        }
        buf.append(" <a href=\"").append(uri).append("?").append(nonce).append("&Cmd=DUMP&Range=ALL").append("\">show DUMP output</a>");
        buf.append(" <a href=\"").append(uri).append("?").append(nonce).append("&Cmd=INFO&Range=ALL").append("\">show INFO output</a>");
        buf.append("\n");
        LinkedHashMap<String, ArrayList<Node>> nodes = new LinkedHashMap<String, ArrayList<Node>>();
        for (Node node : this.container.getNodes()) {
            String domain = node.getNodeConfig().getDomain() != null ? node.getNodeConfig().getDomain() : "";
            ArrayList<Node> list = (ArrayList<Node>)nodes.get(domain);
            if (list == null) {
                list = new ArrayList<Node>();
                nodes.put(domain, list);
            }
            list.add(node);
        }
        for (Map.Entry entry : nodes.entrySet()) {
            String groupName = (String)entry.getKey();
            if (this.reduceDisplay) {
                buf.append("<br/><br/>LBGroup " + groupName + ": ");
            } else {
                buf.append("<h1> LBGroup " + groupName + ": ");
            }
            if (this.allowCmd) {
                this.domainCommandString(buf, uri, MCMPHandler.MCMPAction.ENABLE, groupName);
                this.domainCommandString(buf, uri, MCMPHandler.MCMPAction.DISABLE, groupName);
            }
            for (Node node : (List)entry.getValue()) {
                NodeConfig nodeConfig = node.getNodeConfig();
                if (this.reduceDisplay) {
                    buf.append("<br/><br/>Node " + nodeConfig.getJvmRoute());
                    MCMPWebManager.printProxyStat(buf, node, this.reduceDisplay);
                } else {
                    buf.append("<h1> Node " + nodeConfig.getJvmRoute() + " (" + nodeConfig.getConnectionURI() + "): </h1>\n");
                }
                if (this.allowCmd) {
                    this.nodeCommandString(buf, uri, MCMPHandler.MCMPAction.ENABLE, nodeConfig.getJvmRoute());
                    this.nodeCommandString(buf, uri, MCMPHandler.MCMPAction.DISABLE, nodeConfig.getJvmRoute());
                }
                if (!this.reduceDisplay) {
                    buf.append("<br/>\n");
                    buf.append("Balancer: " + nodeConfig.getBalancer() + ",LBGroup: " + nodeConfig.getDomain());
                    String flushpackets = "off";
                    if (nodeConfig.isFlushPackets()) {
                        flushpackets = "Auto";
                    }
                    buf.append(",Flushpackets: " + flushpackets + ",Flushwait: " + nodeConfig.getFlushwait() + ",Ping: " + nodeConfig.getPing() + " ,Smax: " + nodeConfig.getPing() + ",Ttl: " + nodeConfig.getTtl());
                    MCMPWebManager.printProxyStat(buf, node, this.reduceDisplay);
                } else {
                    buf.append("<br/>\n");
                }
                buf.append("\n");
                this.printInfoHost(buf, uri, this.reduceDisplay, this.allowCmd, node);
            }
        }
        buf.append("</body></html>\n");
        resp.send(buf.toString());
    }

    void nodeCommandString(StringBuilder buf, String uri, MCMPHandler.MCMPAction status, String jvmRoute) {
        switch (status) {
            case ENABLE: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=ENABLE-APP&Range=NODE&JVMRoute=" + jvmRoute + "\">Enable Contexts</a> ");
                break;
            }
            case DISABLE: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=DISABLE-APP&Range=NODE&JVMRoute=" + jvmRoute + "\">Disable Contexts</a> ");
            }
        }
    }

    static void printProxyStat(StringBuilder buf, Node node, boolean reduceDisplay) {
        String status = "NOTOK";
        if (node.getStatus() == NodeStatus.NODE_UP) {
            status = "OK";
        }
        if (reduceDisplay) {
            buf.append(" " + status + " ");
        } else {
            buf.append(",Status: " + status + ",Elected: " + node.getElected() + ",Read: " + node.getConnectionPool().getClientStatistics().getRead() + ",Transferred: " + node.getConnectionPool().getClientStatistics().getWritten() + ",Connected: " + node.getConnectionPool().getOpenConnections() + ",Load: " + node.getLoad());
        }
    }

    void domainCommandString(StringBuilder buf, String uri, MCMPHandler.MCMPAction status, String lbgroup) {
        switch (status) {
            case ENABLE: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=ENABLE-APP&Range=DOMAIN&Domain=" + lbgroup + "\">Enable Nodes</a> ");
                break;
            }
            case DISABLE: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=DISABLE-APP&Range=DOMAIN&Domain=" + lbgroup + "\">Disable Nodes</a>");
            }
        }
    }

    void processDomainCmd(HttpServerExchange exchange, String domain, MCMPHandler.MCMPAction action) throws IOException {
        if (domain != null) {
            for (Node node : this.container.getNodes()) {
                if (!domain.equals(node.getNodeConfig().getDomain())) continue;
                this.processNodeCommand(node.getJvmRoute(), action);
            }
        }
        MCMPWebManager.processOK(exchange);
    }

    private void printInfoHost(StringBuilder buf, String uri, boolean reduceDisplay, boolean allowCmd, Node node) {
        String jvmRoute = node.getJvmRoute();
        for (Node.VHostMapping host : node.getVHosts()) {
            if (!reduceDisplay) {
                buf.append("<h2> Virtual Host " + host.getId() + ":</h2>");
            }
            this.printInfoContexts(buf, uri, reduceDisplay, allowCmd, host.getId(), host, node);
            if (reduceDisplay) {
                buf.append("Aliases: ");
                for (String alias : host.getAliases()) {
                    buf.append(alias + " ");
                }
                continue;
            }
            buf.append("<h3>Aliases:</h3>");
            buf.append("<pre>");
            for (String alias : host.getAliases()) {
                buf.append(alias + "\n");
            }
            buf.append("</pre>");
        }
    }

    private void printInfoContexts(StringBuilder buf, String uri, boolean reduceDisplay, boolean allowCmd, long host, Node.VHostMapping vhost, Node node) {
        if (!reduceDisplay) {
            buf.append("<h3>Contexts:</h3>");
        }
        buf.append("<pre>");
        for (Context context : node.getContexts()) {
            if (context.getVhost() != vhost) continue;
            String status = "REMOVED";
            switch (context.getStatus()) {
                case ENABLED: {
                    status = "ENABLED";
                    break;
                }
                case DISABLED: {
                    status = "DISABLED";
                    break;
                }
                case STOPPED: {
                    status = "STOPPED";
                }
            }
            buf.append(context.getPath() + " , Status: " + status + " Request: " + context.getActiveRequests() + " ");
            if (allowCmd) {
                this.contextCommandString(buf, uri, context.getStatus(), context.getPath(), vhost.getAliases(), node.getJvmRoute());
            }
            buf.append("\n");
        }
        buf.append("</pre>");
    }

    void contextCommandString(StringBuilder buf, String uri, Context.Status status, String path, List<String> alias, String jvmRoute) {
        switch (status) {
            case DISABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=ENABLE-APP&Range=CONTEXT&");
                MCMPWebManager.contextString(buf, path, alias, jvmRoute);
                buf.append("\">Enable</a> ");
                break;
            }
            case ENABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=DISABLE-APP&Range=CONTEXT&");
                MCMPWebManager.contextString(buf, path, alias, jvmRoute);
                buf.append("\">Disable</a> ");
            }
        }
    }

    static void contextString(StringBuilder buf, String path, List<String> alias, String jvmRoute) {
        buf.append("JVMRoute=" + jvmRoute + "&Alias=");
        boolean first = true;
        for (String a : alias) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(a);
        }
        buf.append("&Context=" + path);
    }

    static MCMPHandler.RequestData buildRequestData(HttpServerExchange exchange, Map<String, Deque<String>> params) {
        MCMPHandler.RequestData data = new MCMPHandler.RequestData();
        for (String key : params.keySet()) {
            HttpString name = new HttpString(key);
            data.addValues(name, params.get(key));
        }
        return data;
    }
}

