/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi.modules;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.jaspi.JASPIAuthenticationMechanism;

public class HTTPSchemeServerAuthModule
implements ServerAuthModule {
    private final String securityDomain;
    private AuthenticationMechanism authenticationMechanism;

    public HTTPSchemeServerAuthModule(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void initialize(MessagePolicy messagePolicy, MessagePolicy messagePolicy2, CallbackHandler callbackHandler, Map map) throws AuthException {
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServerExchange exchange = (HttpServerExchange)messageInfo.getMap().get(JASPIAuthenticationMechanism.HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY);
        SecurityContext securityContext = (SecurityContext)messageInfo.getMap().get(JASPIAuthenticationMechanism.SECURITY_CONTEXT_ATTACHMENT_KEY);
        ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        List mechanisms = src.getDeployment().getAuthenticationMechanisms();
        try {
            boolean success = false;
            for (AuthenticationMechanism mechanism : mechanisms) {
                AuthenticationMechanism.AuthenticationMechanismOutcome result = mechanism.authenticate(exchange, securityContext);
                if (result == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                    success = true;
                    break;
                }
                if (result != AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED) continue;
                break;
            }
            if (!success) {
                String mandatory = (String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory");
                if (mandatory != null && mandatory.toLowerCase().equals("false")) {
                    return AuthStatus.SUCCESS;
                }
                for (AuthenticationMechanism mechanism : mechanisms) {
                    AuthenticationMechanism.ChallengeResult challengeResult = mechanism.sendChallenge(exchange, securityContext);
                    if (challengeResult.getDesiredResponseCode() != null) {
                        exchange.setResponseCode(challengeResult.getDesiredResponseCode().intValue());
                    }
                    if (!exchange.isResponseComplete()) continue;
                    break;
                }
                return AuthStatus.SEND_CONTINUE;
            }
        }
        catch (Exception e) {
            UndertowLogger.ROOT_LOGGER.debug(e);
            throw new AuthException("Could not validateRequest using mechanisms [" + mechanisms + ".");
        }
        return AuthStatus.SUCCESS;
    }

    public Class[] getSupportedMessageTypes() {
        return new Class[]{ServletRequest.class, ServletResponse.class, HttpServletRequest.class, HttpServletResponse.class};
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }
}

