/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private final Promise<? super V>[] promises;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promises) {
        if (promises == null) {
            throw new NullPointerException("promises");
        }
        for (Promise<? super V> promise : promises) {
            if (promise != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promises.clone();
    }

    @Override
    public void operationComplete(F future) throws Exception {
        if (future.isSuccess()) {
            Object result = future.get();
            for (Promise promise : this.promises) {
                promise.setSuccess(result);
            }
            return;
        }
        Throwable cause = future.cause();
        for (Promise<V> promise : this.promises) {
            promise.setFailure(cause);
        }
    }
}

