/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.Map;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.AcceptorControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;

public class AcceptorControlImpl
extends AbstractControl
implements AcceptorControl {
    private final Acceptor acceptor;
    private final TransportConfiguration configuration;

    public AcceptorControlImpl(Acceptor acceptor, StorageManager storageManager, TransportConfiguration configuration) throws Exception {
        super(AcceptorControl.class, storageManager);
        this.acceptor = acceptor;
        this.configuration = configuration;
    }

    @Override
    public String getFactoryClassName() {
        this.clearIO();
        try {
            String string = this.configuration.getFactoryClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        this.clearIO();
        try {
            Map<String, Object> map = this.configuration.getParams();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.acceptor.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void start() throws Exception {
        this.clearIO();
        try {
            this.acceptor.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void stop() throws Exception {
        this.clearIO();
        try {
            this.acceptor.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AcceptorControl.class);
    }
}

