/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.qourum.Vote;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;

public class ClusterController
implements ActiveMQComponent {
    private static final boolean isTrace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private final QuorumManager quorumManager;
    private final ActiveMQServer server;
    private Map<SimpleString, ServerLocatorInternal> locators = new HashMap<SimpleString, ServerLocatorInternal>();
    private SimpleString defaultClusterConnectionName;
    private ServerLocator defaultLocator;
    private ServerLocator replicationLocator;
    private final Executor executor;
    private CountDownLatch replicationClusterConnectedLatch;
    private boolean started;
    private SimpleString replicatedClusterName;

    public ClusterController(ActiveMQServer server, ScheduledExecutorService scheduledExecutor) {
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        this.quorumManager = new QuorumManager(scheduledExecutor, this);
    }

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.defaultLocator = this.locators.get(this.defaultClusterConnectionName);
        if (this.replicatedClusterName != null && !this.replicatedClusterName.equals(this.defaultClusterConnectionName)) {
            this.replicationLocator = this.locators.get(this.replicatedClusterName);
            if (this.replicationLocator == null) {
                ActiveMQServerLogger.LOGGER.noClusterConnectionForReplicationCluster();
                this.replicationLocator = this.defaultLocator;
            }
        } else {
            this.replicationLocator = this.defaultLocator;
        }
        this.replicationClusterConnectedLatch = new CountDownLatch(1);
        this.defaultLocator.addClusterTopologyListener(this.quorumManager);
        this.quorumManager.start();
        this.started = true;
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            if (!serverLocatorInternal.isConnectable()) continue;
            this.executor.execute(new ConnectRunnable(serverLocatorInternal));
        }
    }

    @Override
    public void stop() throws Exception {
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            serverLocatorInternal.close();
        }
        this.quorumManager.stop();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public QuorumManager getQuorumManager() {
        return this.quorumManager;
    }

    public void setDefaultClusterConnectionName(SimpleString defaultClusterConnection) {
        this.defaultClusterConnectionName = defaultClusterConnection;
    }

    public void addClusterConnection(SimpleString name, DiscoveryGroupConfiguration dg, ClusterConnectionConfiguration config) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA(dg);
        this.configAndAdd(name, serverLocator, config);
    }

    public void addClusterConnection(SimpleString name, TransportConfiguration[] tcConfigs, ClusterConnectionConfiguration config) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA(tcConfigs);
        this.configAndAdd(name, serverLocator, config);
    }

    private void configAndAdd(SimpleString name, ServerLocatorInternal serverLocator, ClusterConnectionConfiguration config) {
        serverLocator.setConnectionTTL(config.getConnectionTTL());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setReconnectAttempts(-1);
        serverLocator.setInitialConnectAttempts(-1);
        serverLocator.setProtocolManagerFactory(ActiveMQServerSideProtocolManagerFactory.getInstance(serverLocator));
        this.locators.put(name, serverLocator);
    }

    public void addClusterTopologyListenerForReplication(ClusterTopologyListener listener) {
        this.replicationLocator.addClusterTopologyListener(listener);
    }

    public void addIncomingInterceptorForReplication(Interceptor interceptor) {
        this.replicationLocator.addIncomingInterceptor(interceptor);
    }

    public ClusterControl connectToNode(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.defaultLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInReplicatedCluster(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.replicationLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInCluster(ClientSessionFactoryInternal sf) {
        sf.getServerLocator().setProtocolManagerFactory(ActiveMQServerSideProtocolManagerFactory.getInstance(sf.getServerLocator()));
        return new ClusterControl(sf, this.server);
    }

    public long getRetryIntervalForReplicatedCluster() {
        return this.replicationLocator.getRetryInterval();
    }

    public void awaitConnectionToReplicationCluster() throws InterruptedException {
        this.replicationClusterConnectedLatch.await();
    }

    public void addClusterChannelHandler(Channel channel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, Activation activation) {
        channel.setHandler(new ClusterControllerChannelHandler(channel, acceptorUsed, remotingConnection, activation.getActivationChannelHandler(channel, acceptorUsed)));
    }

    public int getDefaultClusterSize() {
        return this.defaultLocator.getTopology().getMembers().size();
    }

    public Topology getDefaultClusterTopology() {
        return this.defaultLocator.getTopology();
    }

    public SimpleString getNodeID() {
        return this.server.getNodeID();
    }

    public String getIdentity() {
        return this.server.getIdentity();
    }

    public void setReplicatedClusterName(String replicatedClusterName) {
        this.replicatedClusterName = new SimpleString(replicatedClusterName);
    }

    public ServerLocator getReplicationLocator() {
        return this.replicationLocator;
    }

    private final class ConnectRunnable
    implements Runnable {
        private ServerLocatorInternal serverLocator;

        public ConnectRunnable(ServerLocatorInternal serverLocator) {
            this.serverLocator = serverLocator;
        }

        @Override
        public void run() {
            try {
                this.serverLocator.connect();
                if (this.serverLocator == ClusterController.this.replicationLocator) {
                    ClusterController.this.replicationClusterConnectedLatch.countDown();
                }
            }
            catch (ActiveMQException e) {
                if (!ClusterController.this.started) {
                    return;
                }
                ClusterController.this.server.getScheduledPool().schedule(this, this.serverLocator.getRetryInterval(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class ClusterControllerChannelHandler
    implements ChannelHandler {
        private final Channel clusterChannel;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection remotingConnection;
        private final ChannelHandler channelHandler;
        boolean authorized = false;

        public ClusterControllerChannelHandler(Channel clusterChannel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, ChannelHandler channelHandler) {
            this.clusterChannel = clusterChannel;
            this.acceptorUsed = acceptorUsed;
            this.remotingConnection = remotingConnection;
            this.channelHandler = channelHandler;
        }

        @Override
        public void handlePacket(Packet packet) {
            if (!this.authorized) {
                if (packet.getType() == 125) {
                    ClusterConnection clusterConnection = this.acceptorUsed.getClusterConnection();
                    if (clusterConnection == null) {
                        clusterConnection = ClusterController.this.server.getClusterManager().getDefaultConnection(null);
                    }
                    ClusterConnectMessage msg = (ClusterConnectMessage)packet;
                    if (ClusterController.this.server.getConfiguration().isSecurityEnabled() && !clusterConnection.verify(msg.getClusterUser(), msg.getClusterPassword())) {
                        this.clusterChannel.send(new ClusterConnectReplyMessage(false));
                    } else {
                        this.authorized = true;
                        this.clusterChannel.send(new ClusterConnectReplyMessage(true));
                    }
                }
            } else if (packet.getType() == 111) {
                NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                Pair<Object, TransportConfiguration> pair = msg.isBackup() ? new Pair<Object, TransportConfiguration>(null, msg.getConnector()) : new Pair<TransportConfiguration, TransportConfiguration>(msg.getConnector(), msg.getBackupConnector());
                if (isTrace) {
                    ActiveMQServerLogger.LOGGER.trace("Server " + ClusterController.this.server + " receiving nodeUp from NodeID=" + msg.getNodeID() + ", pair=" + pair);
                }
                if (this.acceptorUsed != null) {
                    ClusterConnection clusterConn = this.acceptorUsed.getClusterConnection();
                    if (clusterConn != null) {
                        String scaleDownGroupName = msg.getScaleDownGroupName();
                        clusterConn.nodeAnnounced(msg.getCurrentEventID(), msg.getNodeID(), msg.getBackupGroupName(), scaleDownGroupName, pair, msg.isBackup());
                    } else {
                        ActiveMQServerLogger.LOGGER.debug("Cluster connection is null on acceptor = " + this.acceptorUsed);
                    }
                } else {
                    ActiveMQServerLogger.LOGGER.debug("there is no acceptor used configured at the CoreProtocolManager " + this);
                }
            } else if (packet.getType() == -2) {
                QuorumVoteMessage quorumVoteMessage = (QuorumVoteMessage)packet;
                QuorumVoteHandler voteHandler = ClusterController.this.quorumManager.getVoteHandler(quorumVoteMessage.getHandler());
                quorumVoteMessage.decode(voteHandler);
                Vote vote = ClusterController.this.quorumManager.vote(quorumVoteMessage.getHandler(), quorumVoteMessage.getVote());
                this.clusterChannel.send(new QuorumVoteReplyMessage(quorumVoteMessage.getHandler(), vote));
            } else if (packet.getType() == -6) {
                ScaleDownAnnounceMessage message = (ScaleDownAnnounceMessage)packet;
                if (ClusterController.this.server.getNodeID().equals(message.getTargetNodeId())) {
                    ClusterController.this.server.addScaledDownNode(message.getScaledDownNodeId());
                }
            } else if (this.channelHandler != null) {
                this.channelHandler.handlePacket(packet);
            }
        }
    }
}

