/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;

final class EJBHomeInterceptor
implements EJBClientInterceptor {
    EJBHomeInterceptor() {
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext invocationContext) throws Exception {
        invocationContext.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext invocationContext) throws Exception {
        Object originalResult = invocationContext.getResult();
        if (originalResult == null) {
            return originalResult;
        }
        if (!this.isEJBHomeInvocation(invocationContext)) {
            return originalResult;
        }
        boolean isCreateMethod = this.isCreateMethodInvocation(invocationContext);
        boolean isFinderMethod = this.isFinderMethod(invocationContext);
        boolean finderReturnTypeCollection = false;
        if (!isCreateMethod && !isFinderMethod) {
            return originalResult;
        }
        if (isCreateMethod) {
            if (!EJBClient.isEJBProxy(originalResult)) {
                return originalResult;
            }
        } else if (isFinderMethod) {
            if (!(originalResult instanceof Collection) && !EJBClient.isEJBProxy(originalResult)) {
                return originalResult;
            }
            if (originalResult instanceof Collection) {
                for (Object finderResult : (Collection)originalResult) {
                    if (finderResult == null || EJBClient.isEJBProxy(finderResult)) continue;
                    return originalResult;
                }
                finderReturnTypeCollection = true;
            }
        }
        if (finderReturnTypeCollection) {
            Collection ejbProxies = (Collection)originalResult;
            ArrayList recreatedEJBProxies = new ArrayList();
            for (Object ejbProxy : ejbProxies) {
                if (ejbProxy == null) {
                    recreatedEJBProxies.add(null);
                    continue;
                }
                EJBLocator ejbLocator = EJBClient.getLocatorFor(ejbProxy);
                EJBClientContextIdentifier ejbClientContextIdentifier = invocationContext.getInvocationHandler().getEjbClientContextIdentifier();
                Object recreatedProxy = EJBClient.createProxy(ejbLocator, ejbClientContextIdentifier);
                recreatedEJBProxies.add(recreatedProxy);
            }
            return recreatedEJBProxies;
        }
        Object ejbProxy = originalResult;
        EJBLocator<Object> ejbLocator = EJBClient.getLocatorFor(ejbProxy);
        EJBClientContextIdentifier ejbClientContextIdentifier = invocationContext.getInvocationHandler().getEjbClientContextIdentifier();
        return EJBClient.createProxy(ejbLocator, ejbClientContextIdentifier);
    }

    private boolean isEJBHomeInvocation(EJBClientInvocationContext invocationContext) {
        EJBLocator<?> locator = invocationContext.getLocator();
        return locator instanceof EJBHomeLocator;
    }

    private boolean isCreateMethodInvocation(EJBClientInvocationContext invocationContext) {
        Method invokedMethod = invocationContext.getInvokedMethod();
        return invokedMethod.getName().startsWith("create");
    }

    private boolean isFinderMethod(EJBClientInvocationContext invocationContext) {
        Method invokedMethod = invocationContext.getInvokedMethod();
        return invokedMethod.getName().equals("findByPrimaryKey") || invokedMethod.getName().startsWith("find");
    }
}

