/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.server.deployment.scanner.DeploymentScannerExtension;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class FileSystemDeploymentScanHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "run-scan";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("run-scan", DeploymentScannerExtension.getResourceDescriptionResolver("deployment.scanner")).build();
    public static final FileSystemDeploymentScanHandler INSTANCE = new FileSystemDeploymentScanHandler();

    private FileSystemDeploymentScanHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final FileSystemDeploymentService scanner = FileSystemDeploymentScanHandler.this.getExistingScanner(context, operation);
                if (scanner != null) {
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.KEEP) {
                                scanner.singleScan();
                            }
                        }
                    });
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private FileSystemDeploymentService getExistingScanner(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceController serviceController = context.getServiceRegistry(true).getService(DeploymentScannerService.getServiceName(name));
        if (serviceController != null && serviceController.getState() == ServiceController.State.UP) {
            DeploymentScannerService service = (DeploymentScannerService)serviceController.getService();
            return (FileSystemDeploymentService)service.getValue();
        }
        return null;
    }
}

