/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.entity;

import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.InvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.entity.ReadOnlyAccess;
import org.hibernate.cache.infinispan.entity.ReadWriteAccess;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.infinispan.AdvancedCache;

public class EntityRegionImpl
extends BaseTransactionalDataRegion
implements EntityRegion {
    public EntityRegionImpl(AdvancedCache cache, String name, TransactionManager transactionManager, CacheDataDescription metadata, RegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, name, transactionManager, metadata, factory, cacheKeysFactory);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        this.checkAccessType(accessType);
        if (!this.getCacheDataDescription().isMutable()) {
            accessType = AccessType.READ_ONLY;
        }
        InvalidationCacheAccessDelegate accessDelegate = InvalidationCacheAccessDelegate.create(this, this.getValidator());
        switch (accessType) {
            case READ_ONLY: {
                return new ReadOnlyAccess(this, accessDelegate);
            }
            case READ_WRITE: 
            case TRANSACTIONAL: {
                return new ReadWriteAccess(this, accessDelegate);
            }
        }
        throw new CacheException("Unsupported access type [" + accessType.getExternalName() + "]");
    }
}

