/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.session.ActiveSessionStatistics;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.RecordableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionContext;

public class DistributableSessionManagerFactory
implements io.undertow.servlet.api.SessionManagerFactory {
    private final SessionManagerFactory<Batch> factory;

    public DistributableSessionManagerFactory(SessionManagerFactory<Batch> factory) {
        this.factory = factory;
    }

    public SessionManager createSessionManager(Deployment deployment) {
        boolean statisticsEnabled = deployment.getDeploymentInfo().getMetricsCollector() != null;
        RecordableInactiveSessionStatistics inactiveSessionStatistics = statisticsEnabled ? new RecordableInactiveSessionStatistics() : null;
        UndertowSessionContext context = new UndertowSessionContext(deployment);
        IdentifierFactoryAdapter factory = new IdentifierFactoryAdapter(deployment.getDeploymentInfo().getSessionIdGenerator());
        final org.wildfly.clustering.web.session.SessionManager manager = this.factory.createSessionManager((SessionContext)context, (IdentifierFactory)factory, (LocalContextFactory)new LocalSessionContextFactory(), (Recordable)inactiveSessionStatistics);
        DeploymentInfo info = deployment.getDeploymentInfo();
        ThreadSetupAction action = new ThreadSetupAction(){

            public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
                return new ThreadSetupAction.Handle(){

                    public void tearDown() {
                        Batch batch = manager.getBatcher().suspendBatch();
                        if (batch != null) {
                            UndertowLogger.REQUEST_LOGGER.tracef("Suspending residual active batch: %s", (Object)batch);
                        }
                    }
                };
            }
        };
        info.addThreadSetupAction(action);
        DistributableSessionManagerStatistics statistics = inactiveSessionStatistics != null ? new DistributableSessionManagerStatistics((ActiveSessionStatistics)manager, inactiveSessionStatistics) : null;
        return new DistributableSessionManager(info.getDeploymentName(), (org.wildfly.clustering.web.session.SessionManager<LocalSessionContext, Batch>)manager, statistics);
    }
}

