/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.service.Builder;

public class XAResourceRecoveryBuilder
implements Builder<XAResourceRecovery>,
Service<XAResourceRecovery> {
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<XAResourceRecoveryRegistry> registry = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile XAResourceRecovery recovery = null;

    public XAResourceRecoveryBuilder(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return CacheServiceName.XA_RESOURCE_RECOVERY.getServiceName(this.containerName, this.cacheName);
    }

    public ServiceBuilder<XAResourceRecovery> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)this).addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, this.registry).addDependency(CacheServiceName.CACHE.getServiceName(this.containerName), Cache.class, this.cache).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    public XAResourceRecovery getValue() {
        return this.recovery;
    }

    public void start(StartContext context) throws StartException {
        Cache cache = (Cache)this.cache.getValue();
        if (cache.getCacheConfiguration().transaction().recovery().enabled()) {
            this.recovery = new InfinispanXAResourceRecovery(cache);
            ((XAResourceRecoveryRegistry)this.registry.getValue()).addXAResourceRecovery(this.recovery);
        }
    }

    public void stop(StopContext context) {
        if (this.recovery != null) {
            ((XAResourceRecoveryRegistry)this.registry.getValue()).removeXAResourceRecovery(this.recovery);
        }
    }

    private static class InfinispanXAResourceRecovery
    implements XAResourceRecovery {
        private final Cache<?, ?> cache;

        InfinispanXAResourceRecovery(Cache<?, ?> cache) {
            this.cache = cache;
        }

        public XAResource[] getXAResources() {
            return new XAResource[]{this.cache.getAdvancedCache().getXAResource()};
        }

        public int hashCode() {
            return this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName().hashCode() ^ this.cache.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InfinispanXAResourceRecovery)) {
                return false;
            }
            InfinispanXAResourceRecovery recovery = (InfinispanXAResourceRecovery)object;
            return this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName().equals(recovery.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName()) && this.cache.getName().equals(recovery.cache.getName());
        }

        public String toString() {
            return this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName() + "." + this.cache.getName();
        }
    }
}

