/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import org.jboss.as.ee.concurrent.ConcurrentContext;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ConcurrentContextService
implements Service<ConcurrentContext> {
    private final ConcurrentContext concurrentContext;
    private volatile boolean started;

    public ConcurrentContextService(ConcurrentContext concurrentContext) {
        this.concurrentContext = concurrentContext;
    }

    public void start(StartContext context) throws StartException {
        this.started = true;
        this.concurrentContext.setServiceName(context.getController().getName());
    }

    public void stop(StopContext context) {
        this.started = false;
    }

    public ConcurrentContext getValue() throws IllegalStateException, IllegalArgumentException {
        if (!this.started) {
            throw EeLogger.ROOT_LOGGER.serviceNotStarted();
        }
        return this.concurrentContext;
    }
}

