/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    private static final PrivilegedAction<ClassLoader> GET_CLASS_LOADER = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GET_CLASS_LOADER);
    }

    static void addShutdownHook(final Thread shutdownHook) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                    return null;
                }
            });
        }
    }

    static Boolean removeShutdownHook(final Thread shutdownHook) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
        });
    }

    private SecurityActions() {
    }
}

