/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.clustering.singleton.SingletonPolicyBuilder;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentConfiguration;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentProcessor;

public class SingletonDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<SingletonDeploymentConfiguration> CONFIGURATION_KEY = AttachmentKey.create(SingletonDeploymentConfiguration.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = context.getDeploymentUnit();
        if (unit.getParent() != null) {
            return;
        }
        SingletonDeploymentConfiguration config = (SingletonDeploymentConfiguration)unit.getAttachment(CONFIGURATION_KEY);
        if (config != null) {
            context.addDependency(new SingletonPolicyBuilder(config.getPolicy()).getServiceName(), SingletonDeploymentProcessor.POLICY_KEY);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

