/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.file.internal.AbstractFileType;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.annotation.AttributeProperty;

public abstract class AbstractFileAttributedType<T extends AttributedType>
extends AbstractFileType<T> {
    private static final long serialVersionUID = -8312773698663190107L;

    protected AbstractFileAttributedType(String version, T object) {
        super(version, object);
    }

    public String getId() {
        return ((AttributedType)this.getEntry()).getId();
    }

    protected T doCreateInstance(Map<String, Serializable> properties) throws Exception {
        return (T)((AttributedType)Reflections.newInstance(this.getClass(), (String)this.getType()));
    }

    @Override
    protected T doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        T attributedType = this.doCreateInstance(properties);
        attributedType.setId(properties.get("id").toString());
        for (Property<Serializable> property : this.getAttributedProperties(attributedType)) {
            Serializable value = properties.get(property.getName());
            if (value == null) continue;
            property.setValue(attributedType, (Object)value);
        }
        return attributedType;
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        AttributedType attributedType = (AttributedType)this.getEntry();
        properties.put("id", (Serializable)((Object)attributedType.getId()));
        for (Property<Serializable> property : this.getAttributedProperties(attributedType)) {
            Serializable value = (Serializable)property.getValue(this.getEntry());
            if (value == null) continue;
            properties.put(property.getName(), value);
        }
    }

    @Override
    protected void doWriteObject(ObjectOutputStream s) throws Exception {
        super.doWriteObject(s);
    }

    @Override
    protected void doReadObject(ObjectInputStream s) throws Exception {
    }

    private List<Property<Serializable>> getAttributedProperties(T attributedType) {
        PropertyQuery query = PropertyQueries.createQuery(attributedType.getClass());
        query.addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class));
        return query.getResultList();
    }
}

