/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.web.infinispan.SessionIdentifierExternalizer;

public abstract class SessionKeyExternalizer<K extends Key<String>>
implements Externalizer<K> {
    private final Class<K> targetClass;
    private final KeyFactory<K> factory;

    protected SessionKeyExternalizer(Class<K> targetClass, Function<String, K> factory) {
        this(targetClass, (String id, ObjectInput input) -> (Key)factory.apply(id));
    }

    protected SessionKeyExternalizer(Class<K> targetClass, KeyFactory<K> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        SessionIdentifierExternalizer.BASE64.writeObject(output, key.getValue());
    }

    public K readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.factory.createKey((String)SessionIdentifierExternalizer.BASE64.readObject(input), input);
    }

    public Class<? extends K> getTargetClass() {
        return this.targetClass;
    }

    protected static interface KeyFactory<K extends Key<String>> {
        public K createKey(String var1, ObjectInput var2) throws IOException, ClassNotFoundException;
    }
}

