/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.activation.DataHandler;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public final class IOUtils {
    private IOUtils() {
    }

    public static Writer getCharsetFileWriter(File file, String charset) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
    }

    public static String readAndCloseStream(InputStream is) throws IOException {
        return IOUtils.readAndCloseStream(is, "UTF-8");
    }

    public static String readAndCloseStream(InputStream is, String charsetName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copyStream(bos, is);
        return bos.toString(charsetName);
    }

    public static void copyStream(OutputStream outs, InputStream ins) throws IOException {
        try {
            byte[] bytes = new byte[1024];
            int r = ins.read(bytes);
            while (r > 0) {
                outs.write(bytes, 0, r);
                r = ins.read(bytes);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            ins.close();
        }
    }

    public static void copyReader(OutputStream outs, Reader reader) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outs);
            char[] bytes = new char[1024];
            int r = reader.read(bytes);
            while (r > 0) {
                writer.write(bytes, 0, r);
                r = reader.read(bytes);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.close();
        }
    }

    public static byte[] convertToBytes(DataHandler dh) {
        try {
            ByteArrayOutputStream buffOS = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)buffOS);
            return buffOS.toByteArray();
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToConvertDataHandler(e, dh != null ? dh.getName() : null);
        }
    }

    public static File createTempDirectory() throws IOException {
        File tmpdir = null;
        try {
            ServerConfig config = ((ServerConfigFactory)SPIProvider.getInstance().getSPI(ServerConfigFactory.class)).getServerConfig();
            tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/jbossws");
            if (!tmpdir.mkdirs()) {
                tmpdir = null;
            }
        }
        catch (Throwable t) {
            tmpdir = null;
        }
        return tmpdir;
    }
}

