/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.MessageDrivenBeanResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class MessageDrivenBeanRuntimeHandler
extends AbstractEJBComponentRuntimeHandler<MessageDrivenComponent> {
    public static final MessageDrivenBeanRuntimeHandler INSTANCE = new MessageDrivenBeanRuntimeHandler();

    private MessageDrivenBeanRuntimeHandler() {
        super(EJBComponentType.MESSAGE_DRIVEN, MessageDrivenComponent.class);
    }

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, MessageDrivenComponent component, PathAddress address) {
        if (MessageDrivenBeanResourceDefinition.DELIVERY_ACTIVE.getName().equals(attributeName)) {
            context.getResult().set(component.isDeliveryActive());
        } else {
            super.executeReadAttribute(attributeName, context, component, address);
        }
    }

    @Override
    protected boolean isOperationReadOnly(String opName) {
        if ("start-delivery".equals(opName) || "stop-delivery".equals(opName)) {
            return false;
        }
        return super.isOperationReadOnly(opName);
    }

    @Override
    protected void executeAgainstComponent(OperationContext context, ModelNode operation, MessageDrivenComponent component, String opName, PathAddress address) throws OperationFailedException {
        if ("start-delivery".equals(opName)) {
            if (component.isDeliveryControlled()) {
                context.getServiceRegistry(true).getRequiredService(component.getDeliveryControllerName()).setMode(ServiceController.Mode.PASSIVE);
            } else {
                component.startDelivery();
            }
        } else if ("stop-delivery".equals(opName)) {
            if (component.isDeliveryControlled()) {
                context.getServiceRegistry(true).getRequiredService(component.getDeliveryControllerName()).setMode(ServiceController.Mode.NEVER);
            } else {
                component.stopDelivery();
            }
        } else {
            super.executeAgainstComponent(context, operation, component, opName, address);
        }
    }
}

