/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.MultiphaseOverallContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class DomainFinalResultHandler
implements OperationStepHandler {
    private final MultiphaseOverallContext multiphaseContext;
    private final HostControllerExecutionSupport executionSupport;

    DomainFinalResultHandler(MultiphaseOverallContext multiphaseContext, HostControllerExecutionSupport executionSupport) {
        this.multiphaseContext = multiphaseContext;
        this.executionSupport = executionSupport;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Establishing final response -- result action is %s", resultAction);
                boolean isDomain = DomainFinalResultHandler.this.isDomainOperation(operation);
                boolean shouldContinue = DomainFinalResultHandler.this.collectDomainFailure(context, isDomain);
                boolean bl = shouldContinue = shouldContinue && DomainFinalResultHandler.this.collectContextFailure(context, isDomain);
                if (shouldContinue) {
                    ModelNode localDomainFormatted;
                    ModelNode contextResult = context.getResult();
                    contextResult.setEmptyObject();
                    if (DomainFinalResultHandler.this.executionSupport == null) {
                        localDomainFormatted = new ModelNode();
                    } else {
                        ModelNode localResponse = DomainFinalResultHandler.this.multiphaseContext.getLocalContext().getLocalResponse();
                        localDomainFormatted = localResponse.clone();
                        localDomainFormatted.get("result").clear();
                        ModelNode domainResults = DomainFinalResultHandler.this.executionSupport.getFormattedDomainResult(localResponse.get("result"));
                        localDomainFormatted.get(new String[]{"result", "domain-results"}).set(domainResults);
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Domain formatted result for local response %s is %s", localResponse, localDomainFormatted);
                    }
                    contextResult.set(DomainFinalResultHandler.this.getDomainResults(operation, localDomainFormatted, new String[0]));
                    Map<ServerIdentity, ModelNode> serverResults = DomainFinalResultHandler.this.multiphaseContext.getServerResults();
                    if (serverResults.size() > 0) {
                        DomainFinalResultHandler.this.populateServerGroupResults(context, serverResults);
                    } else {
                        shouldContinue = DomainFinalResultHandler.this.collectHostFailures(context, isDomain);
                        if (shouldContinue) {
                            context.getServerResults();
                        }
                    }
                }
                if (!shouldContinue && context.hasResult()) {
                    context.getResult().setEmptyObject();
                }
            }
        });
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.multiphaseContext.getLocalContext().getLocalResponse();
        ModelNode domainFailure = null;
        if (isDomain && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
        }
        if (domainFailure != null) {
            ModelNode fullFailure = new ModelNode();
            fullFailure.get("domain-failure-description").set(domainFailure);
            context.getFailureDescription().set(fullFailure);
            return false;
        }
        return true;
    }

    private boolean collectContextFailure(OperationContext context, boolean isDomain) {
        if (!this.multiphaseContext.isFailureReported() && context.hasFailureDescription()) {
            ModelNode formattedFailure = new ModelNode();
            if (isDomain) {
                ModelNode failure = context.getFailureDescription();
                if (failure.isDefined()) {
                    formattedFailure.get("domain-failure-description").set(failure);
                } else {
                    formattedFailure.get("domain-failure-description").set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
                }
            } else {
                ModelNode hostFailureProperty = new ModelNode();
                ModelNode contextFailure = context.getFailureDescription();
                ModelNode hostFailure = contextFailure.isDefined() ? contextFailure : new ModelNode(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
                hostFailureProperty.add(this.multiphaseContext.getLocalHostInfo().getLocalHostName(), hostFailure);
                formattedFailure.get("host-failure-descriptions").set(hostFailureProperty);
            }
            context.getFailureDescription().set(formattedFailure);
            return false;
        }
        return true;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.multiphaseContext.getHostControllerPreparedResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
            hostFailureResults.get(entry.getKey()).set(desc);
        }
        ModelNode coordinator = this.multiphaseContext.getLocalContext().getLocalResponse();
        if (!isDomain && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
            hostFailureResults.get(this.multiphaseContext.getLocalHostInfo().getLocalHostName()).set(desc);
        }
        if (hostFailureResults != null) {
            if (!context.getFailureDescription().isDefined() || context.getFailureDescription().getType() == ModelType.OBJECT) {
                ModelNode fullFailure = new ModelNode();
                fullFailure.get("host-failure-descriptions").set(hostFailureResults);
                context.getFailureDescription().set(fullFailure);
            } else {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("Failure description is not of type OBJECT '%s'", context.getFailureDescription());
            }
            return false;
        }
        return true;
    }

    private ModelNode getDomainResults(ModelNode operation, ModelNode localDomainFormatted, String ... stepLabels) {
        ResponseProvider provider = new ResponseProvider(operation, this.multiphaseContext.getLocalHostInfo().getLocalHostName());
        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Provider for %s is %s", operation, provider);
        ModelNode result = null;
        if (!provider.isLeaf()) {
            ModelNode compositeResult;
            result = new ModelNode();
            if (stepLabels.length == 0) {
                compositeResult = result;
            } else {
                result.get("outcome").set("success");
                compositeResult = result.get("result");
            }
            String[] nextStepLabels = new String[stepLabels.length + 1];
            System.arraycopy(stepLabels, 0, nextStepLabels, 0, stepLabels.length);
            int i = 1;
            for (ModelNode step : provider.getChildren()) {
                String childStepLabel;
                nextStepLabels[stepLabels.length] = childStepLabel = "step-" + i++;
                compositeResult.get(childStepLabel).set(this.getDomainResults(step, localDomainFormatted, nextStepLabels));
            }
        } else if (provider.getServer() == null) {
            String hostName = provider.getHost();
            if (hostName.equals(this.multiphaseContext.getLocalHostInfo().getLocalHostName())) {
                result = this.getHostControllerResult(localDomainFormatted, stepLabels);
            } else {
                ModelNode hostFinalResult = this.multiphaseContext.getHostControllerFinalResults().get(hostName);
                if (hostFinalResult != null) {
                    result = this.getHostControllerResult(hostFinalResult, stepLabels);
                } else {
                    ModelNode preparedResult = this.multiphaseContext.getHostControllerPreparedResults().get(hostName);
                    if (preparedResult != null) {
                        result = this.getHostControllerResult(preparedResult, stepLabels);
                    }
                }
            }
        } else {
            result = this.multiphaseContext.getServerResult(provider.getHost(), provider.getServer(), stepLabels);
        }
        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Domain result for %s is %s", operation, result);
        return result == null ? new ModelNode() : result;
    }

    private ModelNode getHostControllerResult(ModelNode fullResult, String ... stepLabels) {
        ModelNode result = null;
        if (fullResult != null && fullResult.hasDefined(new String[]{"result", "domain-results"})) {
            ModelNode domainResults = fullResult.get(new String[]{"result", "domain-results"});
            if (stepLabels.length == 0) {
                result = domainResults;
            } else {
                ModelNode source = domainResults;
                for (int i = 0; i < stepLabels.length; ++i) {
                    if (i == 0) {
                        if (source.hasDefined(stepLabels[i])) {
                            source = source.get(stepLabels[i]);
                            continue;
                        }
                        source = new ModelNode();
                        break;
                    }
                    if (source.hasDefined(new String[]{"result", stepLabels[i]})) {
                        source = source.get(new String[]{"result", stepLabels[i]});
                        continue;
                    }
                    source = new ModelNode();
                    break;
                }
                result = source;
            }
            if (result.has("outcome") && !result.hasDefined("outcome")) {
                if (result.hasDefined("failure-description")) {
                    result.get("outcome").set("failed");
                } else {
                    result.get("outcome").set("success");
                }
            }
        }
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Host result from %s at %s is %s", fullResult, Arrays.asList(stepLabels), result);
        }
        return result;
    }

    private void populateServerGroupResults(OperationContext context, Map<ServerIdentity, ModelNode> serverResults) {
        TreeSet<Object> groupNames = new TreeSet<Object>();
        HashMap groupToServerMap = new HashMap();
        for (Map.Entry<ServerIdentity, ModelNode> entry : serverResults.entrySet()) {
            String serverGroup = entry.getKey().getServerGroupName();
            groupNames.add(serverGroup);
            String string = entry.getKey().getHostName();
            String serverName = entry.getKey().getServerName();
            if (!groupToServerMap.containsKey(serverGroup)) {
                groupToServerMap.put(serverGroup, new TreeSet());
            }
            ((Set)groupToServerMap.get(serverGroup)).add(new HostServer(string, serverName, entry.getValue()));
        }
        boolean serverGroupSuccess = false;
        ModelNode failureReport = new ModelNode();
        for (String string : groupNames) {
            ModelNode groupNode = new ModelNode();
            boolean groupFailure = this.multiphaseContext.isServerGroupRollback(string);
            if (!groupFailure) {
                serverGroupSuccess = true;
            }
            for (HostServer hostServer : (Set)groupToServerMap.get(string)) {
                groupNode.get(new String[]{"host", hostServer.hostName, hostServer.serverName, "response"}).set(hostServer.result);
                if (!groupFailure || !hostServer.result.hasDefined("outcome") || !"failed".equals(hostServer.result.get("outcome").asString()) || !hostServer.result.hasDefined("failure-description")) continue;
                ModelNode failDesc = hostServer.result.get("failure-description");
                if (CompositeOperationHandler.getUnexplainedFailureMessage().equals(failDesc.asString())) continue;
                failureReport.get(new String[]{"server-group", string, "host", hostServer.hostName, hostServer.serverName}).set(failDesc);
            }
            context.getServerResults().get(string).set(groupNode);
        }
        if (!serverGroupSuccess) {
            if (failureReport.isDefined()) {
                ModelNode fullFailure = new ModelNode();
                fullFailure.get(DomainControllerLogger.HOST_CONTROLLER_LOGGER.operationFailedOrRolledBackWithCause()).set(failureReport);
                context.getFailureDescription().set(fullFailure);
            } else {
                context.getFailureDescription().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.operationFailedOrRolledBack());
            }
        }
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }

    private static class ResponseProvider {
        private final String host;
        private final String server;
        private final List<ModelNode> children;

        private ResponseProvider(ModelNode operation, String localHostName) {
            boolean composite = "composite".equals(operation.require("operation").asString());
            PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
            int addrSize = opAddr.size();
            if (addrSize == 0) {
                this.host = localHostName;
                this.server = null;
            } else if ("host".equals(opAddr.getElement(0).getKey()) && !opAddr.getElement(0).isMultiTarget()) {
                this.host = opAddr.getElement(0).getValue();
                this.server = addrSize > 1 && "server".equals(opAddr.getElement(1).getKey()) && !opAddr.getElement(1).isMultiTarget() ? opAddr.getElement(1).getValue() : null;
                composite = false;
            } else {
                this.host = localHostName;
                this.server = null;
                composite = false;
            }
            this.children = composite ? (operation.hasDefined("steps") ? new ArrayList<ModelNode>(operation.require("steps").asList()) : Collections.emptyList()) : null;
        }

        private String getHost() {
            return this.host;
        }

        private String getServer() {
            return this.server;
        }

        private List<ModelNode> getChildren() {
            return this.children;
        }

        private boolean isLeaf() {
            return this.children == null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{host=" + this.host + ", server=" + this.server + ", children=" + this.children + "}";
        }
    }

    private static class HostServer
    implements Comparable<HostServer> {
        private final String hostName;
        private final String serverName;
        private final ModelNode result;

        private HostServer(String hostName, String serverName, ModelNode result) {
            this.hostName = hostName;
            this.serverName = serverName;
            this.result = result;
        }

        @Override
        public int compareTo(HostServer hostServer) {
            int hostCompare = this.hostName.compareTo(hostServer.hostName);
            if (hostCompare != 0) {
                return hostCompare;
            }
            return this.serverName.compareTo(hostServer.serverName);
        }
    }
}

