/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalOperationImpl;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.threads.AsyncFuture;

class HostControllerUpdateTask {
    private final String name;
    private final ModelNode operation;
    private final OperationContext context;
    private final TransformingProxyController proxyController;
    private final Transformers.TransformationInputs transformationInputs;

    public HostControllerUpdateTask(String name, ModelNode operation, OperationContext context, TransformingProxyController proxyController, Transformers.TransformationInputs transformationInputs) {
        this.name = name;
        this.context = context;
        this.operation = operation;
        this.proxyController = proxyController;
        this.transformationInputs = transformationInputs;
    }

    public ExecutedHostRequest execute(ProxyOperationListener listener) {
        TransactionalProtocolClient client = this.proxyController.getProtocolClient();
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(this.context);
        DelegatingOperationAttachments operationAttachments = new DelegatingOperationAttachments(this.context);
        SubsystemInfoOperationListener subsystemListener = new SubsystemInfoOperationListener(listener, this.proxyController.getTransformers());
        try {
            OperationTransformer.TransformedOperation transformationResult = this.proxyController.transformOperation(this.transformationInputs, this.operation);
            ModelNode transformedOperation = transformationResult.getTransformedOperation();
            ProxyOperation proxyOperation = new ProxyOperation(this.name, transformedOperation, messageHandler, operationAttachments);
            try {
                if (transformedOperation != null) {
                    transformedOperation.get("operation-headers").set(this.operation.get("operation-headers"));
                    if (!this.operation.equals(transformedOperation)) {
                        transformedOperation.get(new String[]{"operation-headers", "push-to-servers"}).set(true);
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Sending %s (transformed to %s) to %s", this.operation, transformedOperation, this.name);
                    } else {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Sending %s (untransformed) to %s", transformedOperation, this.name);
                    }
                } else {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Sending %s (transformed to null) to %s", this.operation, this.name);
                }
                AsyncFuture result = client.execute((TransactionalProtocolClient.TransactionalOperationListener)subsystemListener, (TransactionalProtocolClient.Operation)proxyOperation);
                return new ExecutedHostRequest((AsyncFuture<OperationResponse>)result, transformationResult);
            }
            catch (IOException e) {
                TransactionalProtocolClient.PreparedOperation result = BlockingQueueOperationListener.FailedOperation.create((TransactionalProtocolClient.Operation)proxyOperation, (Throwable)e);
                subsystemListener.operationPrepared((TransactionalProtocolClient.PreparedOperation<ProxyOperation>)result);
                return new ExecutedHostRequest((AsyncFuture<OperationResponse>)result.getFinalResult(), transformationResult);
            }
        }
        catch (OperationFailedException e) {
            ProxyOperation proxyOperation = new ProxyOperation(this.name, this.operation, messageHandler, operationAttachments);
            TransactionalProtocolClient.PreparedOperation result = BlockingQueueOperationListener.FailedOperation.create((TransactionalProtocolClient.Operation)proxyOperation, (Throwable)e);
            subsystemListener.operationPrepared((TransactionalProtocolClient.PreparedOperation<ProxyOperation>)result);
            return new ExecutedHostRequest((AsyncFuture<OperationResponse>)result.getFinalResult(), OperationResultTransformer.ORIGINAL_RESULT, OperationTransformer.DEFAULT_REJECTION_POLICY);
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }

    private static class SubsystemInfoOperationListener
    implements TransactionalProtocolClient.TransactionalOperationListener<ProxyOperation> {
        private final ProxyOperationListener delegate;
        private final Transformers transformers;

        private SubsystemInfoOperationListener(ProxyOperationListener delegate, Transformers transformers) {
            this.delegate = delegate;
            this.transformers = transformers;
        }

        public void operationPrepared(TransactionalProtocolClient.PreparedOperation<ProxyOperation> prepared) {
            this.delegate.operationPrepared(prepared);
        }

        public void operationFailed(ProxyOperation operation, ModelNode result) {
            this.delegate.operationFailed((TransactionalProtocolClient.Operation)operation, result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ProxyOperation operation, OperationResponse result) {
            try {
                ModelNode responseNode = result.getResponseNode();
                if (responseNode.hasDefined(new String[]{"result", "domain-results"})) {
                    this.storeSubsystemVersions(operation.getOperation(), responseNode.get(new String[]{"result", "domain-results"}));
                }
            }
            finally {
                this.delegate.operationComplete(operation, result);
            }
        }

        private void storeSubsystemVersions(ModelNode operation, ModelNode resultNode) {
            PathAddress address;
            PathAddress pathAddress = address = operation.hasDefined("address") ? PathAddress.pathAddress((ModelNode)operation.get("address")) : PathAddress.EMPTY_ADDRESS;
            if (address.size() == 0 && "composite".equals(operation.get("operation").asString())) {
                List steps = operation.hasDefined("steps") ? operation.get("steps").asList() : Collections.emptyList();
                for (int i = 0; i < steps.size(); ++i) {
                    ModelNode stepOp = (ModelNode)steps.get(i);
                    String resultID = "step-" + (i + 1);
                    if (!resultNode.hasDefined(new String[]{resultID, "result"})) continue;
                    this.storeSubsystemVersions(stepOp, resultNode.get(new String[]{resultID, "result"}));
                }
            } else if (address.size() == 1 && "add".equals(operation.get("operation").asString()) && "extension".equals(address.getElement(0).getKey())) {
                TransformationTarget target = this.transformers.getTarget();
                for (Property p : resultNode.asPropertyList()) {
                    String[] version = p.getValue().asString().split("\\.");
                    int major = Integer.parseInt(version[0]);
                    int minor = Integer.parseInt(version[1]);
                    target.addSubsystemVersion(p.getName(), major, minor);
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("Registering subsystem %s for host %s with major version [%d] and minor version [%d]", new Object[]{p.getName(), address, major, minor});
                }
                resultNode.set(new ModelNode());
            }
        }
    }

    static class ProxyOperationListener
    extends BlockingQueueOperationListener<ProxyOperation> {
        final boolean trace = DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled();

        ProxyOperationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationPrepared(TransactionalProtocolClient.PreparedOperation<ProxyOperation> prepared) {
            try {
                super.operationPrepared(prepared);
            }
            finally {
                if (this.trace) {
                    ModelNode result = prepared.getPreparedResult();
                    String hostName = ((ProxyOperation)prepared.getOperation()).getName();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Received prepared result %s from %s", result, hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ProxyOperation operation, OperationResponse result) {
            try {
                super.operationComplete((TransactionalProtocolClient.Operation)operation, result);
            }
            finally {
                if (this.trace) {
                    String hostName = operation.getName();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Received final result %s from %s", result, hostName);
                }
            }
        }
    }

    static class ExecutedHostRequest
    implements OperationResultTransformer,
    OperationRejectionPolicy {
        private final AsyncFuture<OperationResponse> futureResult;
        private final OperationResultTransformer resultTransformer;
        private final OperationRejectionPolicy rejectPolicy;

        ExecutedHostRequest(AsyncFuture<OperationResponse> futureResult, OperationResultTransformer resultTransformer, OperationRejectionPolicy rejectPolicy) {
            this.futureResult = futureResult;
            this.resultTransformer = resultTransformer;
            this.rejectPolicy = rejectPolicy;
        }

        ExecutedHostRequest(AsyncFuture<OperationResponse> futureResult, OperationTransformer.TransformedOperation transformedOperation) {
            this(futureResult, (OperationResultTransformer)transformedOperation, (OperationRejectionPolicy)transformedOperation);
        }

        public Future<OperationResponse> getFinalResult() {
            return this.futureResult;
        }

        public boolean rejectOperation(ModelNode result) {
            if (result.has(new String[]{"result", "domain-results"})) {
                ModelNode domainResults = result.get(new String[]{"result", "domain-results"});
                if (domainResults.getType() == ModelType.STRING && "ignored-by-unaffected-host-controller".equals(domainResults.asString())) {
                    return false;
                }
                ModelNode userOp = new ModelNode();
                userOp.get("outcome").set("success");
                userOp.get("result").set(domainResults);
                return this.rejectPolicy.rejectOperation(userOp);
            }
            return this.rejectPolicy.rejectOperation(result);
        }

        public String getFailureDescription() {
            return this.rejectPolicy.getFailureDescription();
        }

        public ModelNode transformResult(ModelNode result) {
            boolean reject = this.rejectOperation(result);
            if (reject) {
                result.get("failure-description").set(this.getFailureDescription());
            }
            if (result.has(new String[]{"result", "domain-results"})) {
                ModelNode domainResults = result.get(new String[]{"result", "domain-results"});
                if (domainResults.getType() == ModelType.STRING && "ignored-by-unaffected-host-controller".equals(domainResults.asString())) {
                    return result;
                }
                ModelNode userResult = new ModelNode();
                userResult.get("outcome").set(result.get("outcome"));
                userResult.get("result").set(domainResults);
                if (result.hasDefined("failure-description")) {
                    userResult.get("failure-description").set(result.get("failure-description"));
                }
                ModelNode transformed = this.resultTransformer.transformResult(userResult);
                result.get(new String[]{"result", "domain-results"}).set(transformed.get("result"));
                return result;
            }
            return this.resultTransformer.transformResult(result);
        }

        public void asyncCancel() {
            this.futureResult.asyncCancel(true);
        }
    }

    static class ProxyOperation
    extends TransactionalOperationImpl {
        private final String name;

        protected ProxyOperation(String name, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) {
            super(operation, messageHandler, attachments);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

