/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.group.GroupFilter;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;

public class GroupingInterceptor
extends CommandInterceptor {
    private CacheNotifier<?, ?> cacheNotifier;
    private GroupManager groupManager;
    private InternalEntryFactory factory;
    private boolean isPassivationEnabled;

    @Inject
    public void injectDependencies(CacheNotifier<?, ?> cacheNotifier, GroupManager groupManager, InternalEntryFactory factory, Configuration configuration) {
        this.cacheNotifier = cacheNotifier;
        this.groupManager = groupManager;
        this.factory = factory;
        this.isPassivationEnabled = configuration.persistence().passivation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        command.setGroupOwner(this.isGroupOwner(groupName));
        if (!command.isGroupOwner() || !this.isPassivationEnabled) {
            Object result = this.invokeNextInterceptor(ctx, command);
            if (result instanceof List) {
                this.filter((List)result);
            }
            return result;
        }
        KeyListener listener = new KeyListener(groupName, this.groupManager, this.factory);
        this.cacheNotifier.addListener(listener);
        try {
            Iterator result = this.invokeNextInterceptor(ctx, command);
            if (result instanceof List) {
                ((List)((Object)result)).addAll(listener.activatedKeys);
                this.filter((List)((Object)result));
            } else if (result instanceof Map) {
                for (CacheEntry entry : listener.activatedKeys) {
                    ((Map)((Object)result)).put(entry.getKey(), entry.getValue());
                }
            }
            Iterator iterator = result;
            return iterator;
        }
        finally {
            this.cacheNotifier.removeListener(listener);
        }
    }

    private void filter(List<CacheEntry> list) {
        for (int i = 0; i < list.size(); ++i) {
            CacheEntry entry = list.get(i);
            if (!(entry instanceof MVCCEntry)) continue;
            list.set(i, this.factory.create(entry));
        }
    }

    private boolean isGroupOwner(String groupName) {
        return this.groupManager.isOwner(groupName);
    }

    @Listener
    public static class KeyListener {
        private final ConcurrentLinkedQueue<CacheEntry> activatedKeys;
        private final GroupFilter<Object> filter;
        private final InternalEntryFactory factory;

        public KeyListener(String groupName, GroupManager groupManager, InternalEntryFactory factory) {
            this.factory = factory;
            this.filter = new GroupFilter(groupName, groupManager);
            this.activatedKeys = new ConcurrentLinkedQueue();
        }

        @CacheEntryActivated
        public void handleRemove(CacheEntryActivatedEvent<?, ?> event) {
            Object key = event.getKey();
            if (this.filter.accept(key)) {
                this.activatedKeys.add(this.factory.create(key, event.getValue(), event.getMetadata()));
            }
        }
    }
}

