/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.PartitionStatusChanged;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.ClusterStreamManagerImpl;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalOperation;

public class PartitionAwareClusterStreamManager<K>
extends ClusterStreamManagerImpl<K> {
    protected final PartitionListener listener = new PartitionListener();
    protected Cache<?, ?> cache;

    @Inject
    public void inject(Cache<?, ?> cache) {
        this.cache = cache;
    }

    @Override
    @Start
    public void start() {
        super.start();
        this.cache.addListener(this.listener);
    }

    @Override
    public boolean awaitCompletion(UUID id, long time, TimeUnit unit) throws InterruptedException {
        this.checkPartitionStatus();
        return super.awaitCompletion(id, time, unit);
    }

    @Override
    public <R> UUID remoteStreamOperation(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, TerminalOperation<R> operation, ClusterStreamManager.ResultsCallback<R> callback, Predicate<? super R> earlyTerminatePredicate) {
        this.checkPartitionStatus();
        return super.remoteStreamOperation(parallelDistribution, parallelStream, ch, segments, keysToInclude, keysToExclude, includeLoader, operation, callback, earlyTerminatePredicate);
    }

    @Override
    public <R> UUID remoteStreamOperation(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, KeyTrackingTerminalOperation<K, R, ?> operation, ClusterStreamManager.ResultsCallback<Collection<R>> callback) {
        this.checkPartitionStatus();
        return super.remoteStreamOperation(parallelDistribution, parallelStream, ch, segments, keysToInclude, keysToExclude, includeLoader, operation, callback);
    }

    @Override
    public <R> UUID remoteStreamOperationRehashAware(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, TerminalOperation<R> operation, ClusterStreamManager.ResultsCallback<R> callback, Predicate<? super R> earlyTerminatePredicate) {
        this.checkPartitionStatus();
        return super.remoteStreamOperationRehashAware(parallelDistribution, parallelStream, ch, segments, keysToInclude, keysToExclude, includeLoader, operation, callback, earlyTerminatePredicate);
    }

    @Override
    public <R2> UUID remoteStreamOperationRehashAware(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, KeyTrackingTerminalOperation<K, ?, R2> operation, ClusterStreamManager.ResultsCallback<Map<K, R2>> callback) {
        this.checkPartitionStatus();
        return super.remoteStreamOperationRehashAware(parallelDistribution, parallelStream, ch, segments, keysToInclude, keysToExclude, includeLoader, operation, callback);
    }

    private void checkPartitionStatus() {
        if (this.listener.currentMode != AvailabilityMode.AVAILABLE) {
            throw log.partitionDegraded();
        }
    }

    @Listener
    protected class PartitionListener {
        protected volatile AvailabilityMode currentMode = AvailabilityMode.AVAILABLE;

        protected PartitionListener() {
        }

        @PartitionStatusChanged
        public void onPartitionChange(PartitionStatusChangedEvent<K, ?> event) {
            if (!event.isPre()) {
                this.currentMode = event.getAvailabilityMode();
                if (this.currentMode != AvailabilityMode.AVAILABLE) {
                    PartitionAwareClusterStreamManager.this.currentlyRunning.values().forEach(t -> ClusterStreamManagerImpl.markTrackerWithException(t, null, (Throwable)((Object)new AvailabilityException()), null));
                }
            }
        }
    }
}

