/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.remoting.RpcException;

public class BackupFailureException
extends RpcException {
    private Map<String, Throwable> failures;
    private String localCacheName;

    public BackupFailureException(String localCacheName) {
        this.localCacheName = localCacheName;
    }

    public BackupFailureException() {
    }

    public void addFailure(String site, Throwable t) {
        if (site != null && t != null) {
            if (this.failures == null) {
                this.failures = new HashMap<String, Throwable>(3);
            }
            this.failures.put(site, t);
        }
    }

    public String getRemoteSiteNames() {
        return this.failures != null ? this.failures.keySet().toString() : null;
    }

    public String getLocalCacheName() {
        return this.localCacheName;
    }

    public String toString() {
        if (this.failures == null || this.failures.isEmpty()) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder("The local cache " + this.localCacheName + " failed to backup data to the remote sites:\n");
        for (Map.Entry<String, Throwable> entry : this.failures.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

