/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.securityToken;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.binding.wss10.SecurityTokenReferenceType;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.impl.securityToken.DsaKeyValueSecurityTokenImpl;
import org.apache.wss4j.stax.impl.securityToken.ECKeyValueSecurityTokenImpl;
import org.apache.wss4j.stax.impl.securityToken.RsaKeyValueSecurityTokenImpl;
import org.apache.wss4j.stax.impl.securityToken.X509DefaultSecurityTokenImpl;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.binding.xmldsig.DSAKeyValueType;
import org.apache.xml.security.binding.xmldsig.KeyInfoType;
import org.apache.xml.security.binding.xmldsig.KeyValueType;
import org.apache.xml.security.binding.xmldsig.RSAKeyValueType;
import org.apache.xml.security.binding.xmldsig11.ECKeyValueType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InboundSecurityContext;
import org.apache.xml.security.stax.ext.SecurityContext;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.ext.XMLSecurityUtils;
import org.apache.xml.security.stax.securityToken.InboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenFactory;

public class SecurityTokenFactoryImpl
extends SecurityTokenFactory {
    public InboundSecurityToken getSecurityToken(KeyInfoType keyInfoType, SecurityTokenConstants.KeyUsage keyInfoUsage, XMLSecurityProperties securityProperties, InboundSecurityContext inboundSecurityContext) throws XMLSecurityException {
        Crypto crypto = null;
        if (WSSecurityTokenConstants.KeyUsage_Signature_Verification.equals((Object)keyInfoUsage)) {
            crypto = ((WSSSecurityProperties)securityProperties).getSignatureVerificationCrypto();
        } else if (WSSecurityTokenConstants.KeyUsage_Decryption.equals((Object)keyInfoUsage)) {
            crypto = ((WSSSecurityProperties)securityProperties).getDecryptionCrypto();
        }
        if (keyInfoType != null) {
            SecurityTokenReferenceType securityTokenReferenceType = (SecurityTokenReferenceType)XMLSecurityUtils.getQNameType((List)keyInfoType.getContent(), (QName)WSSConstants.TAG_wsse_SecurityTokenReference);
            if (securityTokenReferenceType != null) {
                return SecurityTokenFactoryImpl.getSecurityToken(securityTokenReferenceType, crypto, ((WSSSecurityProperties)securityProperties).getCallbackHandler(), inboundSecurityContext, (WSSSecurityProperties)securityProperties);
            }
            KeyValueType keyValueType = (KeyValueType)XMLSecurityUtils.getQNameType((List)keyInfoType.getContent(), (QName)WSSConstants.TAG_dsig_KeyValue);
            if (keyValueType != null) {
                return SecurityTokenFactoryImpl.getSecurityToken(keyValueType, crypto, ((WSSSecurityProperties)securityProperties).getCallbackHandler(), (SecurityContext)inboundSecurityContext);
            }
        } else if (crypto != null && crypto.getDefaultX509Identifier() != null) {
            return new X509DefaultSecurityTokenImpl((WSInboundSecurityContext)inboundSecurityContext, crypto, ((WSSSecurityProperties)securityProperties).getCallbackHandler(), crypto.getDefaultX509Identifier(), crypto.getDefaultX509Identifier(), WSSecurityTokenConstants.KeyIdentifier_NoKeyInfo, (WSSSecurityProperties)securityProperties);
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noKeyinfo");
    }

    /*
     * Exception decompiling
     */
    public static InboundSecurityToken getSecurityToken(SecurityTokenReferenceType securityTokenReferenceType, Crypto crypto, CallbackHandler callbackHandler, InboundSecurityContext inboundSecurityContext, WSSSecurityProperties securityProperties) throws XMLSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 29[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InboundSecurityToken getSecurityToken(KeyValueType keyValueType, Crypto crypto, CallbackHandler callbackHandler, SecurityContext securityContext) throws XMLSecurityException {
        RSAKeyValueType rsaKeyValueType = (RSAKeyValueType)XMLSecurityUtils.getQNameType((List)keyValueType.getContent(), (QName)WSSConstants.TAG_dsig_RSAKeyValue);
        if (rsaKeyValueType != null) {
            return new RsaKeyValueSecurityTokenImpl(rsaKeyValueType, (WSInboundSecurityContext)securityContext, crypto);
        }
        DSAKeyValueType dsaKeyValueType = (DSAKeyValueType)XMLSecurityUtils.getQNameType((List)keyValueType.getContent(), (QName)WSSConstants.TAG_dsig_DSAKeyValue);
        if (dsaKeyValueType != null) {
            return new DsaKeyValueSecurityTokenImpl(dsaKeyValueType, (WSInboundSecurityContext)securityContext, crypto);
        }
        ECKeyValueType ecKeyValueType = (ECKeyValueType)XMLSecurityUtils.getQNameType((List)keyValueType.getContent(), (QName)WSSConstants.TAG_dsig11_ECKeyValue);
        if (ecKeyValueType != null) {
            return new ECKeyValueSecurityTokenImpl(ecKeyValueType, (WSInboundSecurityContext)securityContext, crypto);
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "unsupportedKeyInfo");
    }

    private static InboundSecurityToken createSecurityTokenProxy(final InboundSecurityToken inboundSecurityToken, final SecurityTokenConstants.KeyIdentifier keyIdentifier) {
        ArrayList implementedInterfaces = new ArrayList();
        SecurityTokenFactoryImpl.getImplementedInterfaces(inboundSecurityToken.getClass(), implementedInterfaces);
        Class[] interfaces = implementedInterfaces.toArray(new Class[implementedInterfaces.size()]);
        return (InboundSecurityToken)Proxy.newProxyInstance(inboundSecurityToken.getClass().getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getKeyIdentifier")) {
                    return keyIdentifier;
                }
                try {
                    return method.invoke((Object)inboundSecurityToken, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }

    private static void getImplementedInterfaces(Class<?> clazz, List<Class<?>> interfaceList) {
        if (clazz == null) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (!interfaceList.contains(anInterface)) {
                interfaceList.add(anInterface);
            }
            SecurityTokenFactoryImpl.getImplementedInterfaces(anInterface, interfaceList);
        }
        SecurityTokenFactoryImpl.getImplementedInterfaces(clazz.getSuperclass(), interfaceList);
    }
}

