/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.as.server.services.net.SocketBindingRemoveHandler;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class BindingRemoveHandler
extends SocketBindingRemoveHandler {
    public static final BindingRemoveHandler INSTANCE = new BindingRemoveHandler();

    private BindingRemoveHandler() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceController.Substate substate;
        String name = context.getCurrentAddressValue();
        ServiceName svcName = SocketBindingResourceDefinition.SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        ServiceController.Substate substate2 = substate = controller == null ? null : controller.getSubstate();
        if (!context.isResourceServiceRestartAllowed() || substate != null && substate.getState() == ServiceController.State.UP && substate.isRestState()) {
            context.reloadRequired();
        } else {
            context.removeService(svcName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName svcName = SocketBindingResourceDefinition.SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        if (controller != null) {
            context.revertReloadRequired();
        } else {
            try {
                BindingAddHandler.installBindingService(context, model, name);
            }
            catch (UnknownHostException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }
}

