/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.invm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnection;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.remoting.AbstractConnector;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ConnectionLifeCycleListener;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.OrderedExecutorFactory;

public class InVMConnector
extends AbstractConnector {
    public static final Map<String, Object> DEFAULT_CONFIG;
    public static volatile boolean failOnCreateConnection;
    public static volatile int numberOfFailures;
    private static volatile int failures;
    protected final int id;
    private final ClientProtocolManager protocolManager;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final InVMAcceptor acceptor;
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private volatile boolean started;
    protected final OrderedExecutorFactory executorFactory;
    private final Executor closeExecutor;

    public static synchronized void resetFailures() {
        failures = 0;
        failOnCreateConnection = false;
        numberOfFailures = -1;
    }

    private static synchronized void incFailures() {
        if (++failures == numberOfFailures) {
            InVMConnector.resetFailures();
        }
    }

    public InVMConnector(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ClientProtocolManager protocolManager) {
        super(configuration);
        this.listener = listener;
        this.id = ConfigurationHelper.getIntProperty("serverId", 0, configuration);
        this.handler = handler;
        this.closeExecutor = closeExecutor;
        this.executorFactory = new OrderedExecutorFactory(threadPool);
        InVMRegistry registry = InVMRegistry.instance;
        this.acceptor = registry.getAcceptor(this.id);
        this.protocolManager = protocolManager;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public synchronized void close() {
        if (!this.started) {
            return;
        }
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Connection createConnection() {
        if (failOnCreateConnection) {
            InVMConnector.incFailures();
            ActiveMQServerLogger.LOGGER.debug("Returning null on InVMConnector for tests");
            return null;
        }
        if (this.acceptor == null) {
            return null;
        }
        if (this.acceptor.getConnectionsAllowed() == -1L || (long)this.acceptor.getConnectionCount() < this.acceptor.getConnectionsAllowed()) {
            Connection conn = this.internalCreateConnection(this.acceptor.getHandler(), new Listener(), this.acceptor.getExecutorFactory().getExecutor());
            this.acceptor.connect((String)conn.getID(), this.handler, this, this.executorFactory.getExecutor());
            return conn;
        }
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug(new StringBuilder().append("Connection limit of ").append(this.acceptor.getConnectionsAllowed()).append(" reached. Refusing connection."));
        }
        return null;
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    public BufferHandler getHandler() {
        return this.handler;
    }

    public void disconnect(String connectionID) {
        if (!this.started) {
            return;
        }
        Connection conn = (Connection)this.connections.get(connectionID);
        if (conn != null) {
            conn.close();
        }
    }

    protected Connection internalCreateConnection(BufferHandler handler, ConnectionLifeCycleListener listener, Executor serverExecutor) {
        InVMConnection inVMConnection = new InVMConnection(this.id, handler, listener, serverExecutor);
        listener.connectionCreated(null, inVMConnection, this.protocolManager.getName());
        return inVMConnection;
    }

    @Override
    public boolean isEquivalent(Map<String, Object> configuration) {
        int serverId = ConfigurationHelper.getIntProperty("serverId", 0, configuration);
        return this.id == serverId;
    }

    static {
        HashMap<String, Integer> config = new HashMap<String, Integer>();
        config.put("serverId", 0);
        DEFAULT_CONFIG = Collections.unmodifiableMap(config);
        numberOfFailures = -1;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        @Override
        public void connectionCreated(ActiveMQComponent component, Connection connection, String protocol) {
            if (InVMConnector.this.connections.putIfAbsent((String)connection.getID(), connection) != null) {
                throw ActiveMQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            InVMConnector.this.listener.connectionCreated(component, connection, protocol);
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            if (InVMConnector.this.connections.remove(connectionID) != null) {
                InVMConnector.this.acceptor.disconnect((String)connectionID);
                InVMConnector.this.closeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InVMConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        @Override
        public void connectionException(final Object connectionID, final ActiveMQException me) {
            InVMConnector.this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    InVMConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }
}

