/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.CollectionExternalizer;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;

public class CopyOnWriteCollectionExternalizer<T extends Collection<Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<Collection<Object>, T> factory;

    CopyOnWriteCollectionExternalizer(Class targetClass, Function<Collection<Object>, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T collection) throws IOException {
        CollectionExternalizer.writeCollection(output, collection);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = IndexExternalizer.VARIABLE.readData(input);
        return (T)((Collection)this.factory.apply(CollectionExternalizer.readCollection(input, new ArrayList(size), size)));
    }

    public Class<? extends T> getTargetClass() {
        return this.targetClass;
    }

    public static class CopyOnWriteArraySetExternalizer
    extends CopyOnWriteCollectionExternalizer<CopyOnWriteArraySet<Object>> {
        public CopyOnWriteArraySetExternalizer() {
            super(CopyOnWriteArraySet.class, CopyOnWriteArraySet::new);
        }
    }

    public static class CopyOnWriteArrayListExternalizer
    extends CopyOnWriteCollectionExternalizer<CopyOnWriteArrayList<Object>> {
        public CopyOnWriteArrayListExternalizer() {
            super(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new);
        }
    }
}

