/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;

public abstract class Weight {
    protected final Query parentQuery;

    protected Weight(Query query) {
        this.parentQuery = query;
    }

    public abstract void extractTerms(Set<Term> var1);

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract float getValueForNormalization() throws IOException;

    public abstract void normalize(float var1, float var2);

    public abstract Scorer scorer(LeafReaderContext var1) throws IOException;

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        Scorer scorer = this.scorer(context);
        if (scorer == null) {
            return null;
        }
        return new DefaultBulkScorer(scorer);
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
        }

        @Override
        public long cost() {
            return this.scorer.cost();
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            collector.setScorer(this.scorer);
            TwoPhaseIterator twoPhase = this.scorer.asTwoPhaseIterator();
            if (this.scorer.docID() == -1 && min == 0 && max == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, this.scorer, twoPhase, acceptDocs);
                return Integer.MAX_VALUE;
            }
            int doc = this.scorer.docID();
            if (doc < min) {
                doc = twoPhase == null ? this.scorer.advance(min) : twoPhase.approximation().advance(min);
            }
            return DefaultBulkScorer.scoreRange(collector, this.scorer, twoPhase, acceptDocs, doc, max);
        }

        static int scoreRange(LeafCollector collector, Scorer scorer, TwoPhaseIterator twoPhase, Bits acceptDocs, int currentDoc, int end) throws IOException {
            if (twoPhase == null) {
                while (currentDoc < end) {
                    if (acceptDocs == null || acceptDocs.get(currentDoc)) {
                        collector.collect(currentDoc);
                    }
                    currentDoc = scorer.nextDoc();
                }
                return currentDoc;
            }
            DocIdSetIterator approximation = twoPhase.approximation();
            while (currentDoc < end) {
                if ((acceptDocs == null || acceptDocs.get(currentDoc)) && twoPhase.matches()) {
                    collector.collect(currentDoc);
                }
                currentDoc = approximation.nextDoc();
            }
            return currentDoc;
        }

        static void scoreAll(LeafCollector collector, Scorer scorer, TwoPhaseIterator twoPhase, Bits acceptDocs) throws IOException {
            if (twoPhase == null) {
                int doc = scorer.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector.collect(doc);
                    }
                    doc = scorer.nextDoc();
                }
            } else {
                DocIdSetIterator approximation = twoPhase.approximation();
                int doc = approximation.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                        collector.collect(doc);
                    }
                    doc = approximation.nextDoc();
                }
            }
        }
    }
}

