/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.codec;

import java.util.Arrays;
import org.cryptacular.codec.AbstractBaseNDecoder;

public class Base64Decoder
extends AbstractBaseNDecoder {
    private static final byte[] DEFAULT_DECODING_TABLE;
    private static final byte[] URLSAFE_DECODING_TABLE;

    public Base64Decoder() {
        this(false);
    }

    public Base64Decoder(boolean urlSafe) {
        super(urlSafe ? URLSAFE_DECODING_TABLE : DEFAULT_DECODING_TABLE);
    }

    @Override
    protected int getBlockLength() {
        return 24;
    }

    @Override
    protected int getBitsPerChar() {
        return 6;
    }

    static {
        int i;
        DEFAULT_DECODING_TABLE = new byte[128];
        URLSAFE_DECODING_TABLE = new byte[128];
        Arrays.fill(DEFAULT_DECODING_TABLE, (byte)-1);
        for (i = 0; i < 26; ++i) {
            Base64Decoder.DEFAULT_DECODING_TABLE[i + 65] = (byte)i;
        }
        for (i = 0; i < 26; ++i) {
            Base64Decoder.DEFAULT_DECODING_TABLE[i + 97] = (byte)(i + 26);
        }
        for (i = 0; i < 10; ++i) {
            Base64Decoder.DEFAULT_DECODING_TABLE[i + 48] = (byte)(i + 52);
        }
        System.arraycopy(DEFAULT_DECODING_TABLE, 0, URLSAFE_DECODING_TABLE, 0, 128);
        Base64Decoder.DEFAULT_DECODING_TABLE[43] = 62;
        Base64Decoder.DEFAULT_DECODING_TABLE[47] = 63;
        Base64Decoder.URLSAFE_DECODING_TABLE[45] = 62;
        Base64Decoder.URLSAFE_DECODING_TABLE[95] = 63;
    }
}

