/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MulticastAddressValidator
extends StringLengthValidator {
    public MulticastAddressValidator(boolean allowNull, boolean allowExpressions) {
        super(1, allowNull, allowExpressions);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String inetAddr = value.asString();
            try {
                InetAddress mcastAddr = InetAddress.getByName(inetAddr);
                if (!mcastAddr.isMulticastAddress()) {
                    throw ControllerLogger.ROOT_LOGGER.invalidMulticastAddress(inetAddr, parameterName);
                }
            }
            catch (UnknownHostException e) {
                throw ControllerLogger.ROOT_LOGGER.unknownMulticastAddress(e, inetAddr, parameterName);
            }
        }
    }
}

