/*
 * Decompiled with CFR 0.152.
 */
package javax.batch.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobOperator;

public class BatchRuntime {
    public static JobOperator getJobOperator() {
        JobOperator jobOperator = null;
        if (System.getSecurityManager() == null) {
            Iterator<JobOperator> i$ = ServiceLoader.load(JobOperator.class).iterator();
            if (i$.hasNext()) {
                JobOperator op;
                jobOperator = op = i$.next();
            }
        } else {
            jobOperator = AccessController.doPrivileged(new PrivilegedAction<JobOperator>(){

                @Override
                public JobOperator run() {
                    Iterator<JobOperator> i$ = ServiceLoader.load(JobOperator.class).iterator();
                    if (i$.hasNext()) {
                        JobOperator op = i$.next();
                        return op;
                    }
                    return null;
                }
            });
        }
        if (jobOperator == null) {
            throw new BatchRuntimeException("The ServiceLoader was unable to find an implemenation for JobOperator. Check classpath for META-INF/services/javax.batch.operations.JobOperator file.");
        }
        return jobOperator;
    }
}

