/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Set;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class ReplaceCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 11;
    Object oldValue;
    Object newValue;
    Metadata metadata;
    private CacheNotifier notifier;
    boolean successful = true;
    private ValueMatcher valueMatcher;
    private Equivalence valueEquivalence;

    public ReplaceCommand() {
    }

    public ReplaceCommand(Object key, Object oldValue, Object newValue, CacheNotifier notifier, Metadata metadata, Set<Flag> flags, Equivalence valueEquivalence, CommandInvocationId commandInvocationId) {
        super(key, flags, commandInvocationId);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.notifier = notifier;
        this.metadata = metadata;
        this.valueMatcher = oldValue != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_NON_NULL;
        this.valueEquivalence = valueEquivalence;
    }

    public void init(CacheNotifier notifier, Configuration cfg) {
        this.notifier = notifier;
        this.valueEquivalence = cfg.dataContainer().valueEquivalence();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReplaceCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e != null && this.valueMatcher.matches(e, this.oldValue, this.newValue, this.valueEquivalence)) {
            e.setChanged(true);
            Object old = e.setValue(this.newValue);
            if (this.valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW) {
                return this.returnValue(old, e.getMetadata(), true, ctx);
            }
            return this.returnValue(this.oldValue, e.getMetadata(), true, ctx);
        }
        return this.returnValue(null, null, false, ctx);
    }

    private boolean isValueEquals(Object oldValue, Object newValue) {
        if (this.valueEquivalence != null) {
            return this.valueEquivalence.equals(oldValue, newValue);
        }
        return oldValue.equals(newValue);
    }

    private Object returnValue(Object beingReplaced, Metadata previousMetadata, boolean successful, InvocationContext ctx) {
        Object previousValue;
        this.successful = successful;
        Object object = previousValue = this.oldValue == null ? beingReplaced : this.oldValue;
        if (successful) {
            this.notifier.notifyCacheEntryModified(this.key, this.newValue, this.metadata, previousValue, previousMetadata, true, ctx, this);
        }
        if (this.oldValue == null) {
            return beingReplaced;
        }
        return successful;
    }

    @Override
    public byte getCommandId() {
        return 11;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.oldValue, this.newValue, this.metadata, this.valueMatcher, Flag.copyWithoutRemotableFlags(this.flags), this.commandInvocationId};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 11) {
            throw new IllegalArgumentException("Invalid method name");
        }
        this.key = parameters[0];
        this.oldValue = parameters[1];
        this.newValue = parameters[2];
        this.metadata = (Metadata)parameters[3];
        this.valueMatcher = (ValueMatcher)((Object)parameters[4]);
        this.flags = (Set)parameters[5];
        this.commandInvocationId = (CommandInvocationId)parameters[6];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplaceCommand that = (ReplaceCommand)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
        this.successful = this.oldValue == null ? remoteResponse != null : (Boolean)remoteResponse;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "ReplaceCommand{key=" + Util.toStr((Object)this.key) + ", oldValue=" + Util.toStr((Object)this.oldValue) + ", newValue=" + Util.toStr((Object)this.newValue) + ", metadata=" + this.metadata + ", flags=" + this.flags + ", successful=" + this.successful + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + '}';
    }
}

