/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.operator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.operator.ControlOperator;

public class ControlOperatorParser {
    private static final Pattern controlOperatorPattern = Pattern.compile("(2>&1)|(2>>)|(2>)|(>>)|(>)|(<)|(\\|&)|(\\|\\|)|(\\|)|(;)|(&&)|(&)|(\")|(')");
    private static final Pattern redirectionNoPipelinePattern = Pattern.compile("(2>&1)|(2>>)|(2>)|(>>)|(>)|(<)");
    private static final Pattern pipelineAndEndPattern = Pattern.compile("(\\|&)|(\\|)|(;)");
    private static final char ESCAPE = '\\';
    private static final char EQUALS = '=';

    public static boolean doStringContainRedirectionNoPipeline(String buffer) {
        return redirectionNoPipelinePattern.matcher(buffer).find();
    }

    public static boolean doStringContainPipelineOrEnd(String buffer) {
        return pipelineAndEndPattern.matcher(buffer).find();
    }

    public static int getPositionOfFirstRedirection(String buffer) {
        Matcher matcher = redirectionNoPipelinePattern.matcher(buffer);
        if (matcher.find()) {
            return matcher.end();
        }
        return 0;
    }

    public static int findLastPipelineAndEndPositionBeforeCursor(String buffer, int cursor) {
        return ControlOperatorParser.findLastRedirectionOrPipelinePositionBeforeCursor(pipelineAndEndPattern, buffer, cursor);
    }

    public static int findLastRedirectionPositionBeforeCursor(String buffer, int cursor) {
        return ControlOperatorParser.findLastRedirectionOrPipelinePositionBeforeCursor(redirectionNoPipelinePattern, buffer, cursor);
    }

    private static int findLastRedirectionOrPipelinePositionBeforeCursor(Pattern pattern, String buffer, int cursor) {
        Matcher matcher = pattern.matcher(buffer);
        if (cursor > buffer.length()) {
            cursor = buffer.length();
        }
        int end = 0;
        while (matcher.find()) {
            if (matcher.start() > cursor) {
                return end;
            }
            end = matcher.end();
        }
        return end;
    }

    public static List<ConsoleOperation> findAllControlOperators(String buffer) {
        Matcher matcher = controlOperatorPattern.matcher(buffer);
        ArrayList<ConsoleOperation> reOpList = new ArrayList<ConsoleOperation>();
        boolean haveDoubleQuote = false;
        boolean haveSingleQuote = false;
        while (matcher.find()) {
            if (matcher.group(1) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_OUT_AND_ERR, buffer.substring(0, matcher.start(1))));
                buffer = buffer.substring(matcher.end(1));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(2) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.APPEND_ERR, buffer.substring(0, matcher.start(2))));
                buffer = buffer.substring(matcher.end(2));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(3) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_ERR, buffer.substring(0, matcher.start(3))));
                buffer = buffer.substring(matcher.end(3));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(4) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.APPEND_OUT, buffer.substring(0, matcher.start(4))));
                buffer = buffer.substring(matcher.end(4));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(5) != null && !haveDoubleQuote && !haveSingleQuote) {
                if (matcher.start(5) <= 0 || buffer.charAt(matcher.start(5) - 1) == '\\' || buffer.charAt(matcher.start(5) - 1) == '=' || (matcher.start(5) + 1 >= buffer.length() || buffer.charAt(matcher.start(5) + 1) == '=') && matcher.start(5) + 1 != buffer.length()) continue;
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_OUT, buffer.substring(0, matcher.start(5))));
                buffer = buffer.substring(matcher.end(5));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(6) != null && !haveDoubleQuote && !haveSingleQuote) {
                if (matcher.start(6) <= 0 || buffer.charAt(matcher.start(6) - 1) == '\\' || buffer.charAt(matcher.start(6) - 1) == '=' || (matcher.start(6) + 1 >= buffer.length() || buffer.charAt(matcher.start(6) + 1) == '=') && matcher.start(6) + 1 != buffer.length()) continue;
                reOpList.add(new ConsoleOperation(ControlOperator.OVERWRITE_IN, buffer.substring(0, matcher.start(6))));
                buffer = buffer.substring(matcher.end(6));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(7) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.PIPE_OUT_AND_ERR, buffer.substring(0, matcher.start(7))));
                buffer = buffer.substring(matcher.end(7));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(8) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.OR, buffer.substring(0, matcher.start(8))));
                buffer = buffer.substring(matcher.end(8));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(9) != null && !haveDoubleQuote && !haveSingleQuote) {
                if (matcher.start(9) <= 0 || buffer.charAt(matcher.start(9) - 1) == '\\') continue;
                reOpList.add(new ConsoleOperation(ControlOperator.PIPE, buffer.substring(0, matcher.start(9))));
                buffer = buffer.substring(matcher.end(9));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(10) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.END, buffer.substring(0, matcher.start(10))));
                buffer = buffer.substring(matcher.end(10));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(11) != null && !haveDoubleQuote && !haveSingleQuote) {
                reOpList.add(new ConsoleOperation(ControlOperator.AND, buffer.substring(0, matcher.start(11))));
                buffer = buffer.substring(matcher.end(11));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(12) != null && !haveDoubleQuote && !haveSingleQuote) {
                if (matcher.start(12) <= 0 || buffer.charAt(matcher.start(12) - 1) == '\\') continue;
                reOpList.add(new ConsoleOperation(ControlOperator.AMP, buffer.substring(0, matcher.start(12))));
                buffer = buffer.substring(matcher.end(12));
                matcher = controlOperatorPattern.matcher(buffer);
                continue;
            }
            if (matcher.group(13) != null) {
                if (matcher.start(13) != 0 && buffer.charAt(matcher.start(13) - 1) == '\\' || haveSingleQuote) continue;
                haveDoubleQuote = !haveDoubleQuote;
                continue;
            }
            if (matcher.group(14) == null || matcher.start(14) != 0 && buffer.charAt(matcher.start(14) - 1) == '\\' || haveDoubleQuote) continue;
            haveSingleQuote = !haveSingleQuote;
        }
        if (reOpList.size() == 0) {
            reOpList.add(new ConsoleOperation(ControlOperator.NONE, buffer));
        }
        if (buffer.trim().length() > 0) {
            reOpList.add(new ConsoleOperation(ControlOperator.NONE, buffer));
        }
        return reOpList;
    }
}

