/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionMetaData;

public class InfinispanSessionMetaDataFactory<L>
implements SessionMetaDataFactory<InfinispanSessionMetaData<L>, L> {
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> findCreationMetaDataCache;
    private final Cache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final boolean transactional;

    public InfinispanSessionMetaDataFactory(Cache<? extends Key<String>, ?> cache, boolean lockOnRead) {
        this.creationMetaDataCache = cache;
        this.findCreationMetaDataCache = lockOnRead ? this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.creationMetaDataCache;
        this.accessMetaDataCache = cache;
        this.transactional = cache.getCacheConfiguration().transaction().transactionMode().isTransactional();
    }

    public InfinispanSessionMetaData<L> createValue(String id, Void context) {
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent((Object)new SessionCreationMetaDataKey(id), key -> new SessionCreationMetaDataEntry(new SimpleSessionCreationMetaData()));
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent((Object)new SessionAccessMetaDataKey(id), key -> new SimpleSessionAccessMetaData());
        return new InfinispanSessionMetaData(creationMetaDataEntry.getMetaData(), accessMetaData, creationMetaDataEntry.getLocalContext());
    }

    public InfinispanSessionMetaData<L> findValue(String id) {
        return this.getValue(id, this.findCreationMetaDataCache);
    }

    public InfinispanSessionMetaData<L> tryValue(String id) {
        return this.getValue(id, (Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>>)this.findCreationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}));
    }

    private InfinispanSessionMetaData<L> getValue(String id, Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)creationMetaDataCache.get((Object)creationMetaDataKey);
        if (creationMetaDataEntry != null) {
            SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)accessMetaDataKey);
            if (accessMetaData != null) {
                return new InfinispanSessionMetaData(creationMetaDataEntry.getMetaData(), accessMetaData, creationMetaDataEntry.getLocalContext());
            }
            this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)creationMetaDataKey);
        }
        return null;
    }

    @Override
    public SessionMetaData createSessionMetaData(String id, InfinispanSessionMetaData<L> entry) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        CacheEntryMutator creationMutator = this.transactional && this.creationMetaDataCache.getAdvancedCache().getCacheEntry((Object)creationMetaDataKey).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, new SessionCreationMetaDataEntry<L>(entry.getCreationMetaData(), entry.getLocalContext()));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), (Mutator)creationMutator);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        CacheEntryMutator accessMutator = this.transactional && this.accessMetaDataCache.getAdvancedCache().getCacheEntry((Object)accessMetaDataKey).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), (Mutator)accessMutator);
        return new SimpleSessionMetaData(creationMetaData, accessMetaData);
    }

    @Override
    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, InfinispanSessionMetaData<L> entry) {
        return new SimpleSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    public void remove(String id) {
        this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionCreationMetaDataKey(id));
        this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAccessMetaDataKey(id));
    }

    public void evict(String id) {
        this.creationMetaDataCache.evict((Object)new SessionCreationMetaDataKey(id));
        this.accessMetaDataCache.evict((Object)new SessionAccessMetaDataKey(id));
    }
}

