/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;

public class PagedMessageImpl
implements PagedMessage {
    private byte[] largeMessageLazyData;
    private ServerMessage message;
    private long[] queueIDs;
    private long transactionID = 0L;

    public PagedMessageImpl(ServerMessage message, long[] queueIDs, long transactionID) {
        this(message, queueIDs);
        this.transactionID = transactionID;
    }

    public PagedMessageImpl(ServerMessage message, long[] queueIDs) {
        this.queueIDs = queueIDs;
        this.message = message;
    }

    public PagedMessageImpl() {
    }

    @Override
    public ServerMessage getMessage() {
        return this.message;
    }

    @Override
    public void initMessage(StorageManager storage) {
        if (this.largeMessageLazyData != null) {
            LargeServerMessage lgMessage = storage.createLargeMessage();
            ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer(this.largeMessageLazyData);
            lgMessage.decodeHeadersAndProperties(buffer);
            lgMessage.incrementDelayDeletionCount();
            lgMessage.setPaged();
            this.message = lgMessage;
            this.largeMessageLazyData = null;
        }
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public long[] getQueueIDs() {
        return this.queueIDs;
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.transactionID = buffer.readLong();
        boolean isLargeMessage = buffer.readBoolean();
        if (isLargeMessage) {
            int largeMessageHeaderSize = buffer.readInt();
            this.largeMessageLazyData = new byte[largeMessageHeaderSize];
            buffer.readBytes(this.largeMessageLazyData);
        } else {
            buffer.readInt();
            this.message = new ServerMessageImpl(-1L, 50);
            this.message.decode(buffer);
        }
        int queueIDsSize = buffer.readInt();
        this.queueIDs = new long[queueIDsSize];
        for (int i = 0; i < queueIDsSize; ++i) {
            this.queueIDs[i] = buffer.readLong();
        }
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        buffer.writeBoolean(this.message instanceof LargeServerMessage);
        buffer.writeInt(this.message.getEncodeSize());
        this.message.encode(buffer);
        buffer.writeInt(this.queueIDs.length);
        for (long queueID : this.queueIDs) {
            buffer.writeLong(queueID);
        }
    }

    @Override
    public int getEncodeSize() {
        return 13 + this.message.getEncodeSize() + 4 + this.queueIDs.length * 8;
    }

    public String toString() {
        return "PagedMessageImpl [queueIDs=" + Arrays.toString(this.queueIDs) + ", transactionID=" + this.transactionID + ", message=" + this.message + "]";
    }
}

