/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.protocols.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;

public class SpdySynStreamStreamSinkChannel
extends SpdyStreamStreamSinkChannel {
    private final HeaderMap headers;
    private boolean first = true;
    private final Deflater deflater;
    private final int associatedStreamId;

    SpdySynStreamStreamSinkChannel(SpdyChannel channel, HeaderMap headers, int streamId, Deflater deflater, int associatedStreamId) {
        super(channel, streamId);
        this.headers = headers;
        this.deflater = deflater;
        this.associatedStreamId = associatedStreamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        int fcWindow = this.grabFlowControlBytes(this.getBuffer().remaining());
        if (fcWindow == 0 && this.getBuffer().hasRemaining()) {
            return new SendFrameHeader(this.getBuffer().remaining(), null);
        }
        boolean finalFrame = this.isWritesShutdown() && fcWindow >= this.getBuffer().remaining();
        PooledByteBuffer firstHeaderBuffer = ((SpdyChannel)this.getChannel()).getBufferPool().allocate();
        PooledByteBuffer[] allHeaderBuffers = null;
        ByteBuffer firstBuffer = firstHeaderBuffer.getBuffer();
        boolean firstFrame = false;
        if (this.first) {
            firstFrame = true;
            this.first = false;
            int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 1;
            SpdyProtocolUtils.putInt(firstBuffer, firstInt);
            SpdyProtocolUtils.putInt(firstBuffer, 0);
            HeaderMap headers = this.headers;
            SpdyProtocolUtils.putInt(firstBuffer, this.getStreamId());
            SpdyProtocolUtils.putInt(firstBuffer, this.associatedStreamId);
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)0);
            headers.remove(Headers.CONNECTION);
            headers.remove(Headers.KEEP_ALIVE);
            headers.remove(Headers.TRANSFER_ENCODING);
            allHeaderBuffers = this.createHeaderBlock(firstHeaderBuffer, allHeaderBuffers, firstBuffer, headers, this.associatedStreamId > 0);
        }
        PooledByteBuffer currentPooled = allHeaderBuffers == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
        ByteBuffer currentBuffer = currentPooled.getBuffer();
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            remainingInBuffer = this.getBuffer().remaining() - fcWindow;
            this.getBuffer().limit(this.getBuffer().position() + fcWindow);
            if (currentBuffer.remaining() < 8) {
                allHeaderBuffers = this.allocateAll(allHeaderBuffers, currentPooled);
                currentPooled = allHeaderBuffers[allHeaderBuffers.length - 1];
                currentBuffer = currentPooled.getBuffer();
            }
            SpdyProtocolUtils.putInt(currentBuffer, this.getStreamId());
            SpdyProtocolUtils.putInt(currentBuffer, ((finalFrame ? 1 : 0) << 24) + fcWindow);
        } else if (finalFrame && !firstFrame) {
            SpdyProtocolUtils.putInt(currentBuffer, this.getStreamId());
            SpdyProtocolUtils.putInt(currentBuffer, 0x1000000);
        }
        if (allHeaderBuffers == null) {
            currentBuffer.flip();
            return new SendFrameHeader(remainingInBuffer, currentPooled);
        }
        int length = 0;
        for (int i = 0; i < allHeaderBuffers.length; ++i) {
            length += allHeaderBuffers[i].getBuffer().position();
            allHeaderBuffers[i].getBuffer().flip();
        }
        try {
            ByteBuffer newBuf = ByteBuffer.allocate(length);
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                newBuf.put(allHeaderBuffers[i].getBuffer());
            }
            newBuf.flip();
            SendFrameHeader sendFrameHeader = new SendFrameHeader(remainingInBuffer, new ImmediatePooledByteBuffer(newBuf));
            return sendFrameHeader;
        }
        finally {
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                allHeaderBuffers[i].close();
            }
        }
    }

    @Override
    protected boolean isFlushRequiredOnEmptyBuffer() {
        return this.first;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Override
    protected Deflater getDeflater() {
        return this.deflater;
    }
}

