/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

public class FacetRange<T> {
    private static final String MIN_INCLUDED = "[";
    private static final String MIN_EXCLUDED = "(";
    private static final String MAX_INCLUDED = "]";
    private static final String MAX_EXCLUDED = ")";
    private final T min;
    private final T max;
    private final boolean includeMin;
    private final boolean includeMax;
    private final String rangeString;
    private final String fieldName;
    private final Class<?> rangeType;

    public FacetRange(Class<?> rangeType, T min, T max, boolean includeMin, boolean includeMax, String fieldName) {
        if (max == null && min == null) {
            throw new IllegalArgumentException("At least one end of the range has to be specified");
        }
        this.min = min;
        this.max = max;
        this.includeMax = includeMax;
        this.includeMin = includeMin;
        this.fieldName = fieldName;
        this.rangeString = this.buildRangeString();
        this.rangeType = rangeType;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean isMinIncluded() {
        return this.includeMin;
    }

    public boolean isMaxIncluded() {
        return this.includeMax;
    }

    public String getRangeString() {
        return this.rangeString;
    }

    private String buildRangeString() {
        StringBuilder builder = new StringBuilder();
        if (this.includeMin) {
            builder.append(MIN_INCLUDED);
        } else {
            builder.append(MIN_EXCLUDED);
        }
        if (this.min != null) {
            builder.append(this.min);
        }
        builder.append(", ");
        if (this.max != null) {
            builder.append(this.max);
        }
        if (this.includeMax) {
            builder.append(MAX_INCLUDED);
        } else {
            builder.append(MAX_EXCLUDED);
        }
        return builder.toString();
    }

    public String toString() {
        return "FacetRange{min=" + this.min + ", max=" + this.max + ", includeMin=" + this.includeMin + ", includeMax=" + this.includeMax + ", fieldName='" + this.fieldName + '\'' + ", rangeType=" + this.rangeType + '}';
    }
}

