/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter;

import javax.jms.Message;
import org.apache.activemq.artemis.core.protocol.proton.converter.ActiveMQJMSVendor;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.jms.InboundTransformer;
import org.apache.qpid.proton.jms.JMSMappingInboundTransformer;
import org.apache.qpid.proton.jms.JMSMappingOutboundTransformer;
import org.apache.qpid.proton.jms.JMSVendor;

public class ProtonMessageConverter
implements MessageConverter {
    ActiveMQJMSVendor activeMQJMSVendor;
    private final InboundTransformer inboundTransformer;
    private final JMSMappingOutboundTransformer outboundTransformer;

    public ProtonMessageConverter(IDGenerator idGenerator) {
        this.activeMQJMSVendor = new ActiveMQJMSVendor(idGenerator);
        this.inboundTransformer = new JMSMappingInboundTransformer((JMSVendor)this.activeMQJMSVendor);
        this.outboundTransformer = new JMSMappingOutboundTransformer((JMSVendor)this.activeMQJMSVendor);
    }

    public ServerMessage inbound(Object messageSource) throws Exception {
        ServerJMSMessage jmsMessage = this.inboundJMSType((EncodedMessage)messageSource);
        return (ServerMessage)jmsMessage.getInnerMessage();
    }

    public ServerJMSMessage inboundJMSType(EncodedMessage messageSource) throws Exception {
        EncodedMessage encodedMessageSource = messageSource;
        ServerJMSMessage transformedMessage = (ServerJMSMessage)this.inboundTransformer.transform(encodedMessageSource);
        transformedMessage.encode();
        return transformedMessage;
    }

    public Object outbound(ServerMessage messageOutbound, int deliveryCount) throws Exception {
        ServerJMSMessage jmsMessage = this.activeMQJMSVendor.wrapMessage(messageOutbound.getType(), messageOutbound, deliveryCount);
        jmsMessage.decode();
        return this.outboundTransformer.convert((Message)jmsMessage);
    }
}

