/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.PacketsConfirmedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.Ping;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.RollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;

public abstract class PacketDecoder
implements Serializable {
    public abstract Packet decode(ActiveMQBuffer var1);

    public Packet decode(byte packetType) {
        PacketImpl packet;
        switch (packetType) {
            case 10: {
                packet = new Ping();
                break;
            }
            case 11: {
                packet = new DisconnectMessage();
                break;
            }
            case 124: {
                packet = new DisconnectMessage_V2();
                break;
            }
            case 12: {
                packet = new DisconnectConsumerMessage();
                break;
            }
            case 20: {
                packet = new ActiveMQExceptionMessage();
                break;
            }
            case 22: {
                packet = new PacketsConfirmedMessage();
                break;
            }
            case 30: {
                packet = new CreateSessionMessage();
                break;
            }
            case -4: {
                packet = new CheckFailoverMessage();
                break;
            }
            case 31: {
                packet = new CreateSessionResponseMessage();
                break;
            }
            case 32: {
                packet = new ReattachSessionMessage();
                break;
            }
            case 33: {
                packet = new ReattachSessionResponseMessage();
                break;
            }
            case 69: {
                packet = new SessionCloseMessage();
                break;
            }
            case 40: {
                packet = new SessionCreateConsumerMessage();
                break;
            }
            case 41: {
                packet = new SessionAcknowledgeMessage();
                break;
            }
            case 42: {
                packet = new SessionExpireMessage();
                break;
            }
            case 43: {
                packet = new SessionCommitMessage();
                break;
            }
            case 44: {
                packet = new RollbackMessage();
                break;
            }
            case 45: {
                packet = new SessionQueueQueryMessage();
                break;
            }
            case 46: {
                packet = new SessionQueueQueryResponseMessage();
                break;
            }
            case -7: {
                packet = new SessionQueueQueryResponseMessage_V2();
                break;
            }
            case 34: {
                packet = new CreateQueueMessage();
                break;
            }
            case 36: {
                packet = new CreateSharedQueueMessage();
                break;
            }
            case 35: {
                packet = new SessionDeleteQueueMessage();
                break;
            }
            case 49: {
                packet = new SessionBindingQueryMessage();
                break;
            }
            case 50: {
                packet = new SessionBindingQueryResponseMessage();
                break;
            }
            case -8: {
                packet = new SessionBindingQueryResponseMessage_V2();
                break;
            }
            case 51: {
                packet = new SessionXAStartMessage();
                break;
            }
            case 39: {
                packet = new SessionXAAfterFailedMessage();
                break;
            }
            case 52: {
                packet = new SessionXAEndMessage();
                break;
            }
            case 53: {
                packet = new SessionXACommitMessage();
                break;
            }
            case 54: {
                packet = new SessionXAPrepareMessage();
                break;
            }
            case 55: {
                packet = new SessionXAResponseMessage();
                break;
            }
            case 56: {
                packet = new SessionXARollbackMessage();
                break;
            }
            case 57: {
                packet = new SessionXAJoinMessage();
                break;
            }
            case 58: {
                packet = new PacketImpl(58);
                break;
            }
            case 59: {
                packet = new SessionXAResumeMessage();
                break;
            }
            case 60: {
                packet = new SessionXAForgetMessage();
                break;
            }
            case 61: {
                packet = new PacketImpl(61);
                break;
            }
            case 62: {
                packet = new SessionXAGetInDoubtXidsResponseMessage();
                break;
            }
            case 63: {
                packet = new SessionXASetTimeoutMessage();
                break;
            }
            case 64: {
                packet = new SessionXASetTimeoutResponseMessage();
                break;
            }
            case 65: {
                packet = new PacketImpl(65);
                break;
            }
            case 66: {
                packet = new SessionXAGetTimeoutResponseMessage();
                break;
            }
            case 67: {
                packet = new PacketImpl(67);
                break;
            }
            case 68: {
                packet = new PacketImpl(68);
                break;
            }
            case 70: {
                packet = new SessionConsumerFlowCreditMessage();
                break;
            }
            case 74: {
                packet = new SessionConsumerCloseMessage();
                break;
            }
            case 81: {
                packet = new SessionIndividualAcknowledgeMessage();
                break;
            }
            case 21: {
                packet = new NullResponseMessage();
                break;
            }
            case 77: {
                packet = new SessionReceiveContinuationMessage();
                break;
            }
            case 73: {
                packet = new SessionSendContinuationMessage();
                break;
            }
            case 79: {
                packet = new SessionRequestProducerCreditsMessage();
                break;
            }
            case 80: {
                packet = new SessionProducerCreditsMessage();
                break;
            }
            case 82: {
                packet = new SessionProducerCreditsFailMessage();
                break;
            }
            case 78: {
                packet = new SessionForceConsumerDelivery();
                break;
            }
            case 110: {
                packet = new ClusterTopologyChangeMessage();
                break;
            }
            case 114: {
                packet = new ClusterTopologyChangeMessage_V2();
                break;
            }
            case 122: {
                packet = new ClusterTopologyChangeMessage_V3();
                break;
            }
            case 112: {
                packet = new SubscribeClusterTopologyUpdatesMessage();
                break;
            }
            case 113: {
                packet = new SubscribeClusterTopologyUpdatesMessageV2();
                break;
            }
            case 104: {
                packet = new SessionAddMetaDataMessage();
                break;
            }
            case 105: {
                packet = new SessionAddMetaDataMessageV2();
                break;
            }
            case 106: {
                packet = new SessionUniqueAddMetaDataMessage();
                break;
            }
            case -5: {
                packet = new CheckFailoverReplyMessage();
                break;
            }
            default: {
                throw ActiveMQClientMessageBundle.BUNDLE.invalidType(packetType);
            }
        }
        return packet;
    }
}

