/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalize;
import org.jboss.marshalling.FieldSetter;

@Externalize(value=Externalizer.class)
public final class Pair<A, B>
implements Serializable {
    private static final long serialVersionUID = 7331975617882473974L;
    private final A a;
    private final B b;
    private final transient int hashCode;
    private static final FieldSetter setter = FieldSetter.get(Pair.class, "hashCode");

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
        this.hashCode = Pair.hashCode(a, b);
    }

    private static int hashCode(Object a, Object b) {
        return (a == null ? 0 : a.hashCode()) * 1319 + (b == null ? 0 : b.hashCode());
    }

    public A getA() {
        return this.a;
    }

    public B getB() {
        return this.b;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        setter.setInt(this, Pair.hashCode(this.a, this.b));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof Pair ? this.equals((Pair)other) : false;
    }

    public boolean equals(Pair<?, ?> other) {
        if (other == null) {
            return false;
        }
        A a = this.a;
        A othera = other.a;
        B b = this.b;
        B otherb = other.b;
        return (a == othera || a != null && a.equals(othera)) && (b == otherb || b != null && b.equals(otherb));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Pair (").append(this.a).append(", ").append(this.b).append(')');
        return builder.toString();
    }

    public static <A, B> Pair<A, B> create(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public static final class Externalizer
    implements org.jboss.marshalling.Externalizer,
    Externalizable {
        private static final long serialVersionUID = 930391108343329811L;
        private static final Externalizer instance = new Externalizer();

        public static Externalizer getInstance() {
            return instance;
        }

        @Override
        public void writeExternal(Object subject, ObjectOutput output) throws IOException {
            output.writeObject(((Pair)subject).a);
            output.writeObject(((Pair)subject).b);
        }

        @Override
        public Object createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
            return Pair.create(input.readObject(), input.readObject());
        }

        @Override
        public void readExternal(Object subject, ObjectInput input) {
        }

        @Override
        public void writeExternal(ObjectOutput out) {
        }

        @Override
        public void readExternal(ObjectInput in) {
        }

        protected Object readResolve() {
            return instance;
        }
    }
}

