/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SegmentRetryingOperation<E, T, S extends BaseStream<T, S>>
extends BaseTerminalOperation
implements TerminalOperation<E> {
    private static final Log log = LogFactory.getLog(SegmentRetryingOperation.class);
    private static final BaseStream<?, ?> EMPTY = Stream.empty();
    private final Function<S, ? extends E> function;
    private transient AtomicReference<BaseStream<?, ?>> streamRef = new AtomicReference(EMPTY);
    private transient AtomicBoolean continueTrying = new AtomicBoolean(true);

    public SegmentRetryingOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<? extends Stream<?>> supplier, Function<S, ? extends E> function) {
        super(intermediateOperations, supplier);
        this.function = function;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        boolean affected;
        BaseStream<?, ?> oldStream = this.streamRef.get();
        this.continueTrying.set(!stopIfLost);
        if (oldStream != null) {
            if (oldStream != EMPTY) {
                affected = this.streamRef.compareAndSet(oldStream, EMPTY);
                if (affected) {
                    oldStream.close();
                }
            } else {
                affected = true;
            }
        } else {
            affected = false;
        }
        return affected;
    }

    private E innerPerformOperation(BaseStream<?, ?> stream) {
        for (IntermediateOperation intOp : this.intermediateOperations) {
            stream = intOp.perform(stream);
        }
        return this.function.apply(stream);
    }

    @Override
    public E performOperation() {
        E value;
        BaseStream stream;
        boolean keepTrying = true;
        do {
            stream = (BaseStream)this.supplier.get();
            this.streamRef.set(stream);
            value = this.innerPerformOperation(stream);
            log.trace("Completed an operation, trying to see if we are done.");
        } while (!this.streamRef.compareAndSet(stream, null) && (keepTrying = this.continueTrying.get()));
        log.tracef("Operation now done, due to try denial: " + !keepTrying, new Object[0]);
        return (E)(keepTrying ? value : null);
    }

    public Function<S, ? extends E> getFunction() {
        return this.function;
    }
}

