/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.sql.DataSource;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.DataSourceConnectionFactoryConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public abstract class JDBCStoreBuilder<C extends AbstractJdbcStoreConfiguration, B extends AbstractJdbcStoreConfigurationBuilder<C, B>>
extends StoreBuilder {
    private final Class<B> builderClass;
    private volatile ValueDependency<DataSource> dataSourceDepencency;

    JDBCStoreBuilder(Class<B> builderClass, String containerName, String cacheName) {
        super(containerName, cacheName);
        this.builderClass = builderClass;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return this.dataSourceDepencency.register(super.build(target));
    }

    B createStore(OperationContext context, ModelNode model) throws OperationFailedException {
        String dataSource = JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.getDefinition().resolveModelAttribute(context, model).asString();
        this.dataSourceDepencency = new InjectedValueDependency(CommonUnaryRequirement.DATA_SOURCE.getServiceName(context, dataSource), DataSource.class);
        AbstractJdbcStoreConfigurationBuilder storeBuilder = ((AbstractJdbcStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(this.builderClass)).dialect((DatabaseType)ModelNodes.asEnum((ModelNode)JDBCStoreResourceDefinition.Attribute.DIALECT.getDefinition().resolveModelAttribute(context, model), DatabaseType.class));
        ((DataSourceConnectionFactoryConfigurationBuilder)storeBuilder.connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSourceDependency((Value<DataSource>)this.dataSourceDepencency);
        return (B)storeBuilder;
    }
}

