/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExtensionXml {
    private final ModuleLoader moduleLoader;
    private final ExecutorService bootExecutor;
    private final ExtensionRegistry extensionRegistry;

    public ExtensionXml(ModuleLoader loader, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        this.moduleLoader = loader;
        this.bootExecutor = executorService;
        this.extensionRegistry = extensionRegistry;
    }

    public void writeExtensions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set keys = modelNode.keys();
        if (keys.size() > 0) {
            writer.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String extension : keys) {
                writer.writeEmptyElement(Element.EXTENSION.getLocalName());
                writer.writeAttribute(Attribute.MODULE.getLocalName(), extension);
            }
            writer.writeEndElement();
        }
    }

    public void parseExtensions(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        XMLStreamException xse;
        LinkedHashMap<String, Future<XMLStreamException>> loadFutures;
        long start = System.currentTimeMillis();
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> found = new HashSet<String>();
        final XMLMapper xmlMapper = reader.getXMLMapper();
        LinkedHashMap<String, Future<XMLStreamException>> linkedHashMap = loadFutures = this.bootExecutor != null ? new LinkedHashMap<String, Future<XMLStreamException>>() : null;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            Object element = Element.forName(reader.getLocalName());
            if (element != Element.EXTENSION) {
                throw ParseUtils.unexpectedElement(reader);
            }
            final String moduleName = ParseUtils.readStringAttributeElement(reader, Attribute.MODULE.getLocalName());
            if (!found.add(moduleName)) {
                throw ParseUtils.invalidAttributeValue(reader, 0);
            }
            if (loadFutures != null) {
                Callable<XMLStreamException> callable = new Callable<XMLStreamException>(){

                    @Override
                    public XMLStreamException call() throws Exception {
                        return ExtensionXml.this.loadModule(moduleName, xmlMapper);
                    }
                };
                Future<XMLStreamException> future = this.bootExecutor.submit(callable);
                loadFutures.put(moduleName, future);
                continue;
            }
            xse = this.loadModule(moduleName, xmlMapper);
            if (xse != null) {
                throw xse;
            }
            this.addExtensionAddOperation(address, list, moduleName);
        }
        if (loadFutures != null) {
            for (Map.Entry entry : loadFutures.entrySet()) {
                try {
                    xse = (XMLStreamException)((Future)entry.getValue()).get();
                    if (xse != null) {
                        throw xse;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ControllerLogger.ROOT_LOGGER.moduleLoadingInterrupted((String)entry.getKey());
                }
                catch (ExecutionException e) {
                    throw ControllerLogger.ROOT_LOGGER.failedToLoadModule(e, (String)entry.getKey());
                }
                this.addExtensionAddOperation(address, list, (String)entry.getKey());
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        if (ControllerLogger.ROOT_LOGGER.isDebugEnabled()) {
            ControllerLogger.ROOT_LOGGER.debugf("Parsed extensions in [%d] ms", elapsed);
        }
    }

    private void addExtensionAddOperation(ModelNode address, List<ModelNode> list, String moduleName) {
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("extension", moduleName);
        add.get("operation").set("add");
        list.add(add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamException loadModule(String moduleName, XMLMapper xmlMapper) throws XMLStreamException {
        try {
            Module module = this.moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
            boolean initialized = false;
            for (Extension extension : module.loadService(Extension.class)) {
                ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(extension.getClass());
                try {
                    extension.initializeParsers(this.extensionRegistry.getExtensionParsingContext(moduleName, xmlMapper));
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                }
                if (initialized) continue;
                initialized = true;
            }
            if (!initialized) {
                throw ControllerLogger.ROOT_LOGGER.notFound("META-INF/services/", Extension.class.getName(), module.getIdentifier());
            }
            return null;
        }
        catch (ModuleLoadException e) {
            throw ControllerLogger.ROOT_LOGGER.failedToLoadModule(e);
        }
    }
}

