/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RestartParentResourceAddStepHandler;
import org.jboss.as.clustering.controller.RestartParentResourceRemoveStepHandler;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.ForkProtocolResourceRegistrationHandler;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ForkProtocolResourceDefinition
extends ProtocolResourceDefinition {
    final boolean allowRuntimeOnlyRegistration;

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (JGroupsModel.VERSION_4_1_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"add-index"});
        }
    }

    public ForkProtocolResourceDefinition(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory, boolean allowRuntimeOnlyRegistration) {
        super(parentBuilderFactory);
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    @Override
    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(ProtocolResourceDefinition.Attribute.class).addCapabilities(ProtocolResourceDefinition.Capability.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new ProtocolConfigurationBuilderFactory());
        new RestartParentResourceAddStepHandler<ChannelFactory>(this.parentBuilderFactory, (AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                if (ForkProtocolResourceDefinition.this.allowRuntimeOnlyRegistration && context.getRunningMode() == RunningMode.NORMAL) {
                    context.addStep((OperationStepHandler)new ForkProtocolResourceRegistrationHandler(), OperationContext.Stage.MODEL);
                }
            }
        }.register(registration);
        new RestartParentResourceRemoveStepHandler(this.parentBuilderFactory, (RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        for (ProtocolResourceDefinition.DeprecatedAttribute attribute : ProtocolResourceDefinition.DeprecatedAttribute.values()) {
            registration.registerReadOnlyAttribute(attribute.getDefinition(), null);
        }
        super.register(registration);
    }
}

