/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet.spi.BatchEnvironment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JobOperatorService
implements JobOperator,
Service<JobOperator> {
    private final InjectedValue<BatchEnvironment> batchEnvironmentInjector = new InjectedValue();
    private ClassLoader classLoader;
    private JobOperator delegate;
    private final Set<String> allowedJobNames = new LinkedHashSet<String>();
    private final Set<String> allowedJobXmlNames = new LinkedHashSet<String>();

    public synchronized void start(StartContext context) throws StartException {
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            this.classLoader = ((BatchEnvironment)this.batchEnvironmentInjector.getValue()).getClassLoader();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.delegate = BatchRuntime.getJobOperator();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    public synchronized void stop(StopContext context) {
        this.delegate = null;
        this.classLoader = null;
    }

    public JobOperator getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getJobNames() throws JobSecurityException {
        this.checkState();
        JobOperatorService jobOperatorService = this;
        synchronized (jobOperatorService) {
            return new LinkedHashSet<String>(this.allowedJobNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        this.checkState(jobName);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            try {
                int n = this.delegate.getJobInstanceCount(jobName);
                return n;
            }
            catch (NoSuchJobException noSuchJobException) {
                int n = 0;
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                return n;
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        this.checkState(jobName);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            try {
                List list = this.delegate.getJobInstances(jobName, start, count);
                return list;
            }
            catch (NoSuchJobException noSuchJobException) {
                List<JobInstance> list = Collections.emptyList();
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                return list;
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        this.checkState(jobName);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            try {
                List list = this.delegate.getRunningExecutions(jobName);
                return list;
            }
            catch (NoSuchJobException noSuchJobException) {
                List<Long> list = Collections.emptyList();
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                return list;
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            Properties properties = this.delegate.getParameters(executionId);
            return properties;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            boolean valid;
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            String jobXml = jobXMLName.endsWith(".xml") ? jobXMLName : jobXMLName + ".xml";
            JobOperatorService jobOperatorService = this;
            synchronized (jobOperatorService) {
                valid = this.allowedJobXmlNames.contains(jobXml);
            }
            if (valid) {
                long l = this.delegate.start(jobXMLName, jobParameters);
                return l;
            }
            throw BatchLogger.LOGGER.couldNotFindJobXml(jobXMLName);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            long l = this.delegate.restart(executionId, restartParameters);
            return l;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            this.delegate.stop(executionId);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            this.delegate.abandon(executionId);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            JobInstance jobInstance = this.delegate.getJobInstance(executionId);
            return jobInstance;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.validateJob(instance.getJobName());
            List list = this.delegate.getJobExecutions(instance);
            return list;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(executionId);
            this.validateJob(instance.getJobName());
            JobExecution jobExecution = this.delegate.getJobExecution(executionId);
            return jobExecution;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        this.checkState();
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            JobInstance instance = this.delegate.getJobInstance(jobExecutionId);
            this.validateJob(instance.getJobName());
            List list = this.delegate.getStepExecutions(jobExecutionId);
            return list;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }

    protected synchronized void addAllowedJob(String jobXml, String jobName) {
        this.allowedJobXmlNames.add(jobXml);
        this.allowedJobNames.add(jobName);
    }

    Injector<BatchEnvironment> getBatchEnvironmentInjector() {
        return this.batchEnvironmentInjector;
    }

    private void checkState() {
        this.checkState(null);
    }

    private void checkState(String jobName) {
        if (this.delegate == null || this.classLoader == null) {
            throw BatchLogger.LOGGER.jobOperatorServiceStopped();
        }
        if (jobName != null) {
            this.validateJob(jobName);
        }
    }

    private synchronized void validateJob(String name) {
        if (!this.allowedJobNames.contains(name)) {
            throw BatchLogger.LOGGER.noSuchJobException(name);
        }
    }
}

