/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.ClassTableContributor;
import org.wildfly.clustering.marshalling.jboss.HashableMarshalledValue;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValue;

public class DynamicClassTable
extends SimpleClassTable {
    public DynamicClassTable(ClassLoader loader) {
        this((Externalizer<Integer>)IndexExternalizer.VARIABLE, loader);
    }

    public DynamicClassTable(Externalizer<Integer> indexExternalizer, ClassLoader loader) {
        super(indexExternalizer, DynamicClassTable.findClasses(loader));
    }

    private static Class<?>[] findClasses(ClassLoader loader) {
        LinkedList<Class<HashableMarshalledValue>> classes = new LinkedList<Class<HashableMarshalledValue>>();
        classes.add(Serializable.class);
        classes.add(Externalizable.class);
        classes.add(MarshalledValue.class);
        classes.add(SimpleMarshalledValue.class);
        classes.add(HashableMarshalledValue.class);
        ServiceLoader.load(ClassTableContributor.class, loader).forEach(contributor -> classes.addAll(contributor.getKnownClasses()));
        return classes.toArray(new Class[classes.size()]);
    }
}

