/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class XaDataSourceAdd
extends AbstractDataSourceAdd {
    static final XaDataSourceAdd INSTANCE = new XaDataSourceAdd();

    private XaDataSourceAdd() {
        super(XaDataSourceAdd.join((AttributeDefinition[])Constants.XA_DATASOURCE_ATTRIBUTE, (AttributeDefinition[])Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES));
    }

    @Override
    protected AbstractDataSourceService createDataSourceService(String dsName, String jndiName) throws OperationFailedException {
        return new XaDataSourceService(dsName, ContextNames.bindInfoFor((String)jndiName));
    }

    @Override
    protected boolean isXa() {
        return true;
    }

    @Override
    protected void startConfigAndAddDependency(ServiceBuilder<?> dataSourceServiceBuilder, AbstractDataSourceService dataSourceService, String jndiName, ServiceTarget serviceTarget, ModelNode operation) throws OperationFailedException {
        ServiceName dataSourceCongServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        dataSourceServiceBuilder.addDependency(dataSourceCongServiceName, ModifiableXaDataSource.class, ((XaDataSourceService)dataSourceService).getDataSourceConfigInjector());
    }
}

