/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.CookieConfigMetaDataParser;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;

public class SessionConfigMetaDataParser
extends MetaDataElementParser {
    public static SessionConfigMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        SessionConfigMetaData sessionConfig = new SessionConfigMetaData();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (SessionConfigMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    sessionConfig.setId(value);
                    continue block12;
                }
                default: {
                    throw SessionConfigMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SESSION_TIMEOUT: {
                    try {
                        sessionConfig.setSessionTimeout(Integer.valueOf(SessionConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                        continue block13;
                    }
                    catch (NumberFormatException e) {
                        throw SessionConfigMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
                case COOKIE_CONFIG: {
                    sessionConfig.setCookieConfig(CookieConfigMetaDataParser.parse(reader, propertyReplacer));
                    continue block13;
                }
                case TRACKING_MODE: {
                    List<SessionTrackingModeType> trackingModes = sessionConfig.getSessionTrackingModes();
                    if (trackingModes == null) {
                        trackingModes = new ArrayList<SessionTrackingModeType>();
                        sessionConfig.setSessionTrackingModes(trackingModes);
                    }
                    try {
                        trackingModes.add(SessionTrackingModeType.valueOf(SessionConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                        continue block13;
                    }
                    catch (IllegalArgumentException e) {
                        throw SessionConfigMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
            }
            throw SessionConfigMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return sessionConfig;
    }
}

